package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RequestContextWrapper;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.ComprehensiveStatisticalAnalysisServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * 综合统计分析API
 *
 * @author system_generator
 * @date 2025-06-24
 */
@RestController
@Api(tags = "综合统计分析API")
@RequestMapping(value = "/comprehensiveStatisticalAnalysis")
public class ComprehensiveStatisticalAnalysisController extends BaseController {

    @Autowired
    private ComprehensiveStatisticalAnalysisServiceImpl statisticalAnalysisService;

    /**
     * 查询设备分类
     *
     * @param category
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/select/equipmentCategory")
    @ApiOperation(httpMethod = "POST", value = "查询设备分类", notes = "查询设备分类")
    public ResponseModel<List<Map<String, Object>>> queryEquipmentCategory(@RequestBody JSONObject category) {
        String key = category.getString("key") == null ? null : category.getString("key");
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryEquipmentCategory(key));
    }

    /**
     * @param jsonObject
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/select/queryEquipmentSearchData")
    @ApiOperation(httpMethod = "POST", value = "查询设备查询条件", notes = "查询设备查询条件")
    public ResponseModel<JSONArray> queryEquipmentSearchData(@RequestBody JSONObject jsonObject) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryEquipmentSearchData(jsonObject.getString("value")));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryAdvancedSearch/{type}")
    @ApiOperation(httpMethod = "GET", value = "查询高级筛选", notes = "查询高级筛选")
    public ResponseModel<JSONArray> query(@PathVariable String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryAdvancedSearch(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryCompanySearchData")
    @ApiOperation(httpMethod = "GET", value = "查询企业条件", notes = "查询企业条件")
    public ResponseModel<JSONObject> queryCompanySearchData() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryCompanySearchData());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryPersonSearchData")
    @ApiOperation(httpMethod = "GET", value = "查询个人条件", notes = "查询个人条件")
    public ResponseModel<JSONObject> queryPersonSearchData() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryPersonSearchData());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryUnitType")
    @ApiOperation(httpMethod = "GET", value = "查询单位类型", notes = "查询单位类型")
    public ResponseModel<JSONArray> queryUnitType() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryUnitType());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryXK")
    @ApiOperation(httpMethod = "GET", value = "查询许可", notes = "查询许可")
    public ResponseModel<JSONArray> queryXK(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryXK(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryRYLX")
    @ApiOperation(httpMethod = "GET", value = "查询人员类型", notes = "查询人员类型")
    public ResponseModel<JSONArray> queryRYLX(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryRYLX(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryZYXM")
    @ApiOperation(httpMethod = "GET", value = "查询作业项目", notes = "查询作业项目")
    public ResponseModel<JSONArray> queryZYXM(@RequestParam String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryZYXM(type));
    }


    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryUnitByOrgCode")
    @ApiOperation(httpMethod = "GET", value = "根据监管机构查询企业", notes = "根据监管机构查询企业")
    public ResponseModel<JSONArray> queryUnitByOrgCode(@RequestParam String orgCode) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryUnitByOrgCode(orgCode));
    }

    /**
     * 综合统计分析接口分页查询
     *
     * @param map
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "综合统计分析接口分页查询", notes = "综合统计分析接口分页查询")
    public ResponseModel<JSONObject> queryForPage(@RequestBody Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryForPage(jsonObject));
    }

    /**
     * 综合统计分析接口-导出
     *
     * @param map 入参
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/export")
    @ApiOperation(httpMethod = "POST", value = "综合统计分析接口-导出", notes = "综合统计分析接口-导出")
    public ResponseModel<String> export(@RequestBody Map<String, Object> map) {
        String uuid = UUID.randomUUID().toString();
        statisticalAnalysisService.startDownLoadMsg("综合统计分析设备列表", uuid);
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        new Thread(() -> {
            contextWrapper.apply();
            statisticalAnalysisService.export(uuid, new JSONObject(map));
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }


}
