package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.StCommonServiceImpl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@RestController
@Api(tags = "统计公共API")
@RequestMapping(value = "/st-common")
public class StCommonController extends BaseController {

    private StCommonServiceImpl commonService;

    public StCommonController(StCommonServiceImpl commonService) {
        this.commonService = commonService;
    }

    /**
     * 获取用户regionCode
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUserRegincode")
    @ApiOperation(httpMethod = "GET", value = "获取用户regionCode", notes = "获取用户regionCode")
    public ResponseModel<List<RegionModel>> getUserReginCode() {
        List<RegionModel> regionList = commonService.getUserRegionCode(getSelectedOrgInfo());
        return ResponseHelper.buildResponse(regionList);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/3level/region-tree")
    @ApiOperation(httpMethod = "GET", value = "获取用户regionCode", notes = "获取用户regionCode")
    public ResponseModel<List<RegionModel>> getReginTree(@RequestParam(value = "regionCode") Integer regionCode) {
        List<RegionModel> regionList = commonService.getRegionTree3Level(regionCode);
        return ResponseHelper.buildResponse(regionList);
    }

    /**
     * 获取设备类型
     * @return Map
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getEquCategoryTree")
    @ApiOperation(httpMethod = "POST", value = "获取设备类型", notes = "获取设备类型")
    public ResponseModel<JSONArray> getEquCategoryTree(@RequestBody DPFilterParamForDetailDto paramDto){
        JSONArray objects = new JSONArray();
        objects.add(commonService.getEquCategoryTree(paramDto));
        return ResponseHelper.buildResponse(objects);
    }
}
