package com.yeejoin.amos.boot.module.tcm.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class QualificationProjectConverter implements Converter<String> {

    private static final Map<String,String> CODE_MAP = new HashMap<>();

    static {
        CODE_MAP.put("机电类设备检验","JDG");
        CODE_MAP.put("承压类设备检验","CYG");
        CODE_MAP.put("大型游乐设施检验","YLY");
        CODE_MAP.put("型式试验","CXY");
        CODE_MAP.put("锅炉检验","GLY");
        CODE_MAP.put("锅炉能效测试","GNY");
        CODE_MAP.put("锅炉水（介）质检验","GSY");
        CODE_MAP.put("压力容器检验","RQY");
        CODE_MAP.put("气瓶检验","QPY");
        CODE_MAP.put("压力管道检验","GDY");
        CODE_MAP.put("电梯检验","DTY");
        CODE_MAP.put("起重机械检验","QZY");
        CODE_MAP.put("客运索道检验","SDY");
        CODE_MAP.put("场（厂）内专用机动车辆检验","CCY");
    }

    @Override
    public Class supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String cellDataStr = cellData.getStringValue();
        return CODE_MAP.get(cellDataStr);
    }

    @Override
    public CellData convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
}
