package com.yeejoin.amos.boot.module.tcm.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class TestProjectConverter implements Converter<String> {

    private static final Map<String,String> CODE_MAP = new HashMap<>();

    static {
        CODE_MAP.put("声发射检测","ZZXM_III");
        CODE_MAP.put("涡流检测","ZZXM_III");
        CODE_MAP.put("渗透检测","ZZXM_III");
        CODE_MAP.put("磁粉检测","ZZXM_III");
        CODE_MAP.put("脉冲反射法超声检测","ZZXM_III");
        CODE_MAP.put("射线数字成像检测","ZZXM_II");
        CODE_MAP.put("脉冲反射法超声检测（自动）","ZZXM_II");
        CODE_MAP.put("衍射时差法超声检测","ZZXM_II");
        CODE_MAP.put("相控阵超声检测","ZZXM_II");
        CODE_MAP.put("涡流检测(自动)","ZZXM_II");
        CODE_MAP.put("漏磁检测(自动)","ZZXM_II");
        CODE_MAP.put("射线胶片照相检测","ZZXM_II");
    }

    @Override
    public Class supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String cellDataStr = cellData.getStringValue();
        return CODE_MAP.get(cellDataStr);
    }

    @Override
    public CellData convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
}
