package com.yeejoin.amos.boot.module.tcm.api.dto;

import cn.afterturn.easypoi.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.module.tcm.api.converter.*;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.*;

@Data
public class CompanyUserImportDto {

    @NotBlank(message = "姓名不能为空！")
    @ExcelProperty(value = "姓名")
    private String name;

    @NotBlank(message = "联系电话不能为空！")
    @ExcelProperty(value = "联系电话")
    private String phone;

    @NotBlank(message = "证件类型不能为空！")
    @ExcelProperty(value = "证件类型", converter = CertificateTypeConverter.class)
    private String certificateType;


    @NotBlank(message = "证件编号不能为空！")
    @ExcelProperty(value = "证件编号")
    private String certificateNum;

    @NotBlank(message = "人员类型不能为空！")
//    @ExcelProperty(value = "人员类型", converter = PostTypeConverter.class)
    @ExcelProperty(value = "人员类型")
    private String post;

    @ExcelIgnore
    private String newPost;

    //    @ExcelProperty(value = "人员子类型", converter = PostTypeConverter.class)
    @ExcelProperty(value = "人员子类型")
    private String subPost;


    @ExcelProperty(value = "性别", converter = GenderConverter.class)
    private String gender;

    @ExcelProperty(value = "出生日期")
    @DateTimeFormat("yyyy-MM-dd")
    private Date birthday;

    @ExcelProperty(value = "学历", converter = EducationConverter.class)
    private String education;

    @ExcelProperty(value = "住址")
    private String address;

    @ExcelProperty(value = "邮箱")
    private String email;

    @ExcelProperty(value = "职称")
    private String jobTitle;

    @ExcelProperty(value = "专业")
    private String speciality;

    @ExcelIgnore()
    private JSONArray permissionData66151 = new JSONArray();

    @ExcelIgnore()
    private JSONArray permissionData66152 = new JSONArray();

    @ExcelIgnore()
    private JSONArray permissionData6552 = new JSONArray();

    /**
     * 检验资质信息
     */
    @Data
    public static class InspectQualification {

        @NotBlank(message = "证件编号不能为空！")
        @ExcelProperty(value = "证件编号")
        private String certificateNum;

        @NotBlank(message = "检验资质发证机关不能为空！")
        @ExcelProperty(value = "证书编号")
        private String certNo;

        @NotBlank(message = "发证机关不能为空！")
        @ExcelProperty(value = "发证机关")
        private String approvedOrgan;

        @NotBlank(message = "检验资质级别不能为空！")
        @ExcelProperty(value = "级别", converter = QualificationLevelConverter.class)
        private String permissionLevel;

        @NotBlank(message = "检验资质项目不能为空！")
        @ExcelProperty(value = "项目", converter = QualificationProjectConverter.class)
        private String permissionItem;

        @NotBlank(message = "检验资质发证日期不能为空！")
        @ExcelProperty(value = "发证日期")
        @DateTimeFormat("yyyy-MM-dd")
        private String issueDate;

        @NotBlank(message = "检验资质有效期不能为空！")
        @ExcelProperty(value = "有效期")
        @DateTimeFormat("yyyy-MM-dd")
        private String expiryDate;

    }

    /**
     * 检测资质信息
     */
    @Data
    public static class TestingQualification {
        @NotBlank(message = "证件编号不能为空！")
        @ExcelProperty(value = "证件编号")
        private String certificateNum;

        @NotBlank(message = "检测资质发证机关不能为空！")
        @ExcelProperty(value = "证书编号")
        private String certNo;

        @NotBlank(message = "发证机关不能为空！")
        @ExcelProperty(value = "发证机关")
        private String approvedOrgan;

        @NotBlank(message = "检测资质级别不能为空！")
        @ExcelProperty(value = "级别", converter = TestLevelConverter.class)
        private String permissionLevel;

        @NotBlank(message = "检测资质项目不能为空！")
        @ExcelProperty(value = "项目", converter = TestProjectConverter.class)
        private String permissionItem;

        @NotBlank(message = "检测资质发证日期不能为空！")
        @ExcelProperty(value = "发证日期")
        @DateTimeFormat("yyyy-MM-dd")
        private String issueDate;

        @NotBlank(message = "检测资质有效期不能为空！")
        @ExcelProperty(value = "有效期")
        @DateTimeFormat("yyyy-MM-dd")
        private String expiryDate;
    }

    /**
     * 作业人员资质信息
     */
    @Data
    public static class OperatorQualifications {
        @NotBlank(message = "作业人员资质证件编号不能为空！")
        @ExcelProperty(value = "证件编号")
        private String certificateNum;

        @NotBlank(message = "作业人员资质发证机关不能为空！")
        @ExcelProperty(value = "证书编号")
        private String certNo;

        @NotBlank(message = "作业人员资质证书类型不能为空！")
        @ExcelProperty(value = "发证机关")
        private String approvedOrgan;

        @NotBlank(message = "作业人员资质证书类型不能为空！")
        @ExcelProperty(value = "证书类型")
        private String certType;

        @NotBlank(message = "作业人员资质作业项目不能为空！")
        @ExcelProperty(value = "作业项目")
        private String jobItemStr;

        @ExcelIgnore
        private JSONArray jobItem;

        @ExcelProperty(value = "金属焊接操作-项目代号")
        private String JSHJCZItemCode;

        @ExcelProperty(value = "非金属焊接操作-项目代号")
        private String FJSHJCZItemCode;

        @ExcelProperty(value = "其他作业项目")
        private String otherItem;

        @NotBlank(message = "检测资质发证日期不能为空！")
        @ExcelProperty(value = "发证日期")
        @DateTimeFormat("yyyy-MM-dd")
        private String issueDate;

        @NotBlank(message = "检测资质有效期不能为空！")
        @ExcelProperty(value = "有效期")
        @DateTimeFormat("yyyy-MM-dd")
        private String expiryDate;
    }
}
