package com.yeejoin.equipmanage.common.enums;

public enum NoticeEnum{
	
	RK("01", "入库通知"),
	CK("02", "出库通知"),
	DB ("03", "调拨通知"),
	TYBF("04", "退役报废通知"),
	INVENTORY("05", "盘点通知"),
	BORROW("06", "借用通知"),
	MAINTIAN("07", "保养通知"),
	CHECK("08", "检查通知"),
	AUTORK("09","自动入库"),
	AUTOCK("10","自动出库"),
	OTHERRK("11","其他仓库入库"),
	DBRK("12","调拨入库"),
	DBCK("13","调拨出库"),
	DBZL("15","调拨指令"),
	TY("16","退役通知"),
	BF("17","报废通知"),
	REPAIR("18","维修通知");
	//TRANSFER("12","货位转移");

	/**
	 * code
	 */
	private String code;
	
	/**
	 * 名称
	 */
	private String name;
	
	/**
	 * 类型
	 */
	private String type;
	
	private NoticeEnum(String code, String name) {
		this.setCode(code);
		this.setName(name);
		this.setType("NoticeType");
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	public static NoticeEnum NoticeEnum(String code) {
		NoticeEnum noticeEnum = null;
		for(NoticeEnum type: NoticeEnum.values()) {
			if (type.getCode().equals(code)) {
				noticeEnum = type;
				break;
			}
		}
		
		return noticeEnum;
	}
	
	public static NoticeEnum getEnumByName(String name)
	{
		for(NoticeEnum type: NoticeEnum.values()) {
			if (type.getName().equals(name)) {
				return type;
			}
		}
		return null;
	}
	
	public static String getCodeByName(String name)
	{
		for(NoticeEnum type: NoticeEnum.values()) {
			if (type.getName().equals(name)) {
				return type.getCode();
			}
		}
		return null;
	}
}
