package com.yeejoin.amos.boot.module.jxiop.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.module.jxiop.api.entity.CommonFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 人员基本信息
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PersonBasicDto", description="人员基本信息")
public class PersonBasicDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "性别( 0-男 1-女 )")
    private String sex;

    @ApiModelProperty(value = "生日")
    private Date birthday;

    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ApiModelProperty(value = "籍贯")
    private String nativePlace;

    @ApiModelProperty(value = "民族")
    private String folkKey;

    @ApiModelProperty(value = "政治面貌")
    private String politicCountenance;

    @ApiModelProperty(value = "户籍地址")
    private String registeredResidenceAddress;

    @ApiModelProperty(value = "现住址")
    private String presentAddress;

    @ApiModelProperty(value = "应急电话")
    private String emergencyPhone;

    @ApiModelProperty(value = "电话")
    private String phone;

    @ApiModelProperty(value = "身高（厘米）")
    private Integer height;

    @ApiModelProperty(value = "体重（千克）")
    private Integer weight;

    @ApiModelProperty(value = "参加工作时间")
    private Date workTime;

    @ApiModelProperty(value = "组织机构id")
    private String projectOrgCode;

    @ApiModelProperty(value = "人员头像")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> headPhoto;

    @ApiModelProperty(value = "证件照片正面")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> frontCertificatePhoto;

    @ApiModelProperty(value = "证件照片反面")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> backCertificatePhoto;

    @ApiModelProperty(value = "进入本单位工作时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date stationWorkTime;

    @ApiModelProperty(value = "工作所在地key")
    private String workPlaceKey;

    @ApiModelProperty(value = "岗位")
    private String postName;

}
