package com.yeejoin.precontrol.common.task;

import java.util.TimerTask;

import javax.servlet.ServletContext;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import com.yeejoin.precontrol.common.entity.TaskRiskControl;
import com.yeejoin.precontrol.common.entity.TaskTimedTask;
import com.yeejoin.precontrol.common.enums.MessageAttributeEnum;
import com.yeejoin.precontrol.common.enums.MessageSubTypeEnum;
import com.yeejoin.precontrol.common.enums.MessageTypeEnum;
import com.yeejoin.precontrol.common.enums.TaskPersonTypeEnum;
import com.yeejoin.precontrol.common.exception.BaseException;
import com.yeejoin.precontrol.common.publish.MessageEventPublish;
import com.yeejoin.precontrol.common.service.ITaskPersonService;
import com.yeejoin.precontrol.common.service.ITaskRiskControlService;
import com.yeejoin.precontrol.common.service.ITaskTimedTaskService;
import com.yeejoin.precontrol.common.utils.SpringUtils;

public class RiskTimerTask extends TimerTask {

	private Long taskId;

	public RiskTimerTask(Long taskId) {
		this.taskId = taskId;
	}

	@Override
	public void run() {
		try {
			ITaskRiskControlService iTaskRiskControlService  = SpringUtils.getBean(ITaskRiskControlService.class);
			ITaskPersonService iTaskPersonService  = SpringUtils.getBean(ITaskPersonService.class);
			ITaskTimedTaskService iTaskTimedTaskService  = SpringUtils.getBean(ITaskTimedTaskService.class);
			MessageEventPublish messageEventPublish  = SpringUtils.getBean(MessageEventPublish.class);
			TaskRiskControl taskRiskControl = iTaskRiskControlService
					.getOne(new LambdaQueryWrapper<TaskRiskControl>().eq(TaskRiskControl::getTaskId, taskId));
			if (taskRiskControl == null) {
				throw new BaseException("风险作业任务不存在,taskId：" + taskId);
			}
			JSONObject jsonObject = new JSONObject();
			jsonObject.put(MessageAttributeEnum.MSG_TYPE.getName(), MessageTypeEnum.SERVICE_REMINDER.getType());
			jsonObject.put(MessageAttributeEnum.MSG_SUB_TYPE.getName(),
					MessageSubTypeEnum.SERVICE_REMINDER_RISK_WORK_EXAM_KNOWLEDGE_EXPIRE.getType());
			jsonObject.put(MessageAttributeEnum.PERSON_ID.getName(), taskRiskControl.getSecPersonId());
			jsonObject.put(MessageAttributeEnum.CONTENT.getName(),
					MessageSubTypeEnum.SERVICE_REMINDER_RISK_WORK_EXAM_KNOWLEDGE_EXPIRE.getTip());
			jsonObject.put(MessageAttributeEnum.TASK_ID.getName(), taskId);

			TaskPerson taskPerson = iTaskPersonService.getOne(new LambdaQueryWrapper<TaskPerson>()
					.eq(TaskPerson::getTaskId, taskId).eq(TaskPerson::getType, TaskPersonTypeEnum.DIRECTOR.getValue()));
			if (taskPerson == null) {
				throw new BaseException("风险作业任务分包商人员不存在,taskId：" + taskId);
			}
			JSONObject jsonObject1 = new JSONObject();
			jsonObject1.put(MessageAttributeEnum.MSG_TYPE.getName(), MessageTypeEnum.SERVICE_REMINDER.getType());
			jsonObject1.put(MessageAttributeEnum.MSG_SUB_TYPE.getName(),
					MessageSubTypeEnum.SERVICE_REMINDER_RISK_WORK_EXAM_KNOWLEDGE_EXPIRE.getType());
			jsonObject1.put(MessageAttributeEnum.PERSON_ID.getName(), taskPerson.getPersonId());
			jsonObject1.put(MessageAttributeEnum.CONTENT.getName(),
					MessageSubTypeEnum.SERVICE_REMINDER_RISK_WORK_EXAM_KNOWLEDGE_EXPIRE.getTip());
			jsonObject1.put(MessageAttributeEnum.TASK_ID.getName(), taskId);
			JSONArray jsonArray = new JSONArray();
			jsonArray.add(jsonObject);
			jsonArray.add(jsonObject1);
			JSONObject obj = new JSONObject();
			obj.put("param", jsonArray);
			messageEventPublish.publish(obj);

			TaskTimedTask taskTimedTask = new TaskTimedTask();
			taskTimedTask.setExecuted(true);
			iTaskTimedTaskService.update(taskTimedTask,
					new LambdaQueryWrapper<TaskTimedTask>().eq(TaskTimedTask::getTaskId, taskId));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
}
