package com.yeejoin.amos.boot.module.elevator.biz.service.impl;


import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertStatisticsDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.AlertStatistics;
import com.yeejoin.amos.boot.module.elevator.api.mapper.AlertStatisticsMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.IAlertStatisticsService;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;


@Service
public class AlertStatisticsServiceImpl extends BaseService<AlertStatisticsDto, AlertStatistics, AlertStatisticsMapper> implements IAlertStatisticsService {

    private static final String REGULATOR_UNIT_TREE = "REGULATOR_UNIT_TREE";

    @Autowired
    RedisUtils redisUtils;

    @Scheduled(cron = "0 0 0 1 * ?")
    @SchedulerLock(name = "AlertStatisticsServiceImpl", lockAtMostFor = "PT10M", lockAtLeastFor = "PT10M")
    public void statisticalGenerationTask(){
        statisticalGeneration(null);
    }

    @Override
    public void statisticalGeneration(String type) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if (ObjectUtils.isEmpty(type)){
            cal.add(Calendar.MONTH, -1);
        }
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMinimum(Calendar.DAY_OF_MONTH));
        Date firstDayOfMonth = cal.getTime();
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date lastDayOfMonth = cal.getTime();
        ArrayList<AlertStatistics> list = new ArrayList<>();
        List<LinkedHashMap> supervisionList = getSupervisionList();
        if (!ObjectUtils.isEmpty(supervisionList)) {
            supervisionList.forEach(item -> {
                if (!ObjectUtils.isEmpty(item.get("orgCode"))) {
                    AlertStatistics statissticsMessage = this.getBaseMapper().getStatissticsMessage(String.valueOf(item.get("orgCode")), format.format(firstDayOfMonth) + " 00:00:00", format.format(lastDayOfMonth) + " 23:59:59");
                    statissticsMessage.setSupervisoryUnitName(String.valueOf(item.get("companyName")));
                    statissticsMessage.setSupervisoryUnitOrgCode(String.valueOf(item.get("orgCode")));
                    statissticsMessage.setSupervisoryUnitId(String.valueOf(item.get("sequenceNbr")));
                    statissticsMessage.setStartDate(format.format(firstDayOfMonth));
                    statissticsMessage.setEndDate(format.format(lastDayOfMonth));
                    statissticsMessage.setStatisticsDate(format.format(lastDayOfMonth).substring(0, 7));
                    list.add(statissticsMessage);
                }
            });
        }
        this.saveBatch(list);
    }


    public List<LinkedHashMap> getSupervisionList() {
        List<LinkedHashMap> data = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
        if (!ObjectUtils.isEmpty(data)) {
            data = (List<LinkedHashMap>) data.get(0).get("children");
        }
        return data;
    }

    @Override
    public List<AlertStatistics> getList(String date) throws ParseException {
        LambdaQueryWrapper<AlertStatistics> lambda = new QueryWrapper<AlertStatistics>().lambda();
        lambda.eq(AlertStatistics::getStatisticsDate, date);
        List<AlertStatistics> alertStatistics = this.getBaseMapper().selectList(lambda);
        AlertStatistics statistics = new AlertStatistics();
        String startDate = null;
        String endDate = null;
        if (!ObjectUtils.isEmpty(alertStatistics)){
            for (AlertStatistics item : alertStatistics) {
                if (ObjectUtils.isEmpty(startDate)) {
                    startDate = item.getStartDate();
                }
                if (ObjectUtils.isEmpty(endDate)) {
                    endDate = item.getEndDate();
                }
                item.setAvgDaysEmergencyEvents(String.valueOf(item.getEmergencyEvents()));
                item.setAvgDaysBreakdownRescue(String.valueOf(item.getBreakdownRescue()));
                item.setAvgDaysTrappedPeople(String.valueOf(item.getTrappedPeople()));
                statistics.setElevatorNum(ObjectUtils.isEmpty(statistics.getElevatorNum()) ? item.getElevatorNum() : item.getElevatorNum() + statistics.getElevatorNum());
                statistics.setEmergencyEvents(ObjectUtils.isEmpty(statistics.getEmergencyEvents()) ? item.getEmergencyEvents() : item.getEmergencyEvents() + statistics.getEmergencyEvents());
                statistics.setTrappedPeople(ObjectUtils.isEmpty(statistics.getTrappedPeople()) ? item.getTrappedPeople() : item.getTrappedPeople() + statistics.getTrappedPeople());
                statistics.setBreakdownRescue(ObjectUtils.isEmpty(statistics.getBreakdownRescue()) ? item.getBreakdownRescue() : item.getBreakdownRescue() + statistics.getBreakdownRescue());
                statistics.setRescuePersonnel(ObjectUtils.isEmpty(statistics.getRescuePersonnel()) ? item.getRescuePersonnel() : item.getRescuePersonnel() + statistics.getRescuePersonnel());
                statistics.setComplaint(ObjectUtils.isEmpty(statistics.getComplaint()) ? item.getComplaint() : item.getComplaint() + statistics.getComplaint());
                statistics.setAvgDaysEmergencyEvents(ObjectUtils.isEmpty(statistics.getEmergencyEvents()) ? String.valueOf(item.getEmergencyEvents()) : String.valueOf(item.getEmergencyEvents() + statistics.getEmergencyEvents()));
                statistics.setAvgDaysTrappedPeople(ObjectUtils.isEmpty(statistics.getTrappedPeople()) ? String.valueOf(item.getTrappedPeople()) : String.valueOf(item.getTrappedPeople() + statistics.getTrappedPeople()));
                statistics.setAvgDaysBreakdownRescue(ObjectUtils.isEmpty(statistics.getBreakdownRescue()) ? String.valueOf(item.getBreakdownRescue()) : String.valueOf(item.getBreakdownRescue() + statistics.getBreakdownRescue()));
            }
        }else {
           return alertStatistics;
        }
        statistics.setSupervisoryUnitName("合计");
        statistics.setSequenceNbr(0L);
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        DecimalFormat decimalFormatAvg = new DecimalFormat("0.0");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (ObjectUtils.isEmpty(statistics.getEmergencyEvents()) || ObjectUtils.isEmpty(statistics.getElevatorNum()) || statistics.getEmergencyEvents() == 0 || statistics.getElevatorNum() == 0) {
            statistics.setFailureRate("0%");
        } else {
            BigDecimal bigDecimal = new BigDecimal(statistics.getEmergencyEvents().toString());
            BigDecimal bigDecimal1 = new BigDecimal(statistics.getElevatorNum().toString());
            BigDecimal divide = bigDecimal.divide(bigDecimal1, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100"));
            statistics.setFailureRate(decimalFormat.format(divide) + "%");
        }
        alertStatistics.add(statistics);
        AlertStatistics avg = new AlertStatistics();
        avg.setSupervisoryUnitName("平均每天");
        avg.setSequenceNbr(1L);
        long days = 0L;
        if (!ObjectUtils.isEmpty(startDate) && !ObjectUtils.isEmpty(endDate)) {
            days = DateUtil.betweenDay(simpleDateFormat.parse(startDate), simpleDateFormat.parse(endDate), true);
        }
        int avgNum = Integer.parseInt(String.valueOf(days));
        if (!ObjectUtils.isEmpty(statistics.getEmergencyEvents()) && statistics.getEmergencyEvents() != 0 && avgNum != 0) {
            BigDecimal bigDecimal = new BigDecimal(statistics.getEmergencyEvents().toString());
            BigDecimal bigDecimal1 = new BigDecimal(avgNum);
            BigDecimal divide = bigDecimal.divide(bigDecimal1, 6, BigDecimal.ROUND_HALF_UP);
            avg.setAvgDaysEmergencyEvents(decimalFormatAvg.format(divide));
        }else {
            avg.setAvgDaysEmergencyEvents("0");
        }
        if (!ObjectUtils.isEmpty(statistics.getTrappedPeople()) && statistics.getTrappedPeople() != 0 && avgNum != 0) {
            BigDecimal bigDecimal = new BigDecimal(statistics.getTrappedPeople().toString());
            BigDecimal bigDecimal1 = new BigDecimal(avgNum);
            BigDecimal divide = bigDecimal.divide(bigDecimal1, 6, BigDecimal.ROUND_HALF_UP);
            avg.setAvgDaysTrappedPeople(decimalFormatAvg.format(divide));
        }else {
            avg.setAvgDaysTrappedPeople("0");
        }
        if (!ObjectUtils.isEmpty(statistics.getBreakdownRescue()) && statistics.getBreakdownRescue() != 0 && avgNum != 0) {
            BigDecimal bigDecimal = new BigDecimal(statistics.getBreakdownRescue().toString());
            BigDecimal bigDecimal1 = new BigDecimal(avgNum);
            BigDecimal divide = bigDecimal.divide(bigDecimal1, 6, BigDecimal.ROUND_HALF_UP);
            avg.setAvgDaysBreakdownRescue(decimalFormatAvg.format(divide));
        }else {
            avg.setAvgDaysBreakdownRescue("0");
        }
        alertStatistics.add(avg);
        return alertStatistics;
    }
}