package com.yeejoin.amos;

import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;
import com.yeejoin.amos.boot.module.cylinder.biz.listener.FillingRecordSyncListener;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.typroject.tyboot.component.emq.EmqKeeper;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;
import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * <pre>
 * 特种设备服务启动类
 * </pre>
 *
 * @author DELL
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableSwagger2WebMvc
@EnableEurekaClient
@EnableScheduling
@EnableSchedulerLock(defaultLockAtMostFor = "10m")
@MapperScan({ "org.typroject.tyboot.demo.face.orm.dao*", "org.typroject.tyboot.face.*.orm.dao*",
		"org.typroject.tyboot.core.auth.face.orm.dao*", "org.typroject.tyboot.component.*.face.orm.dao*",
		"com.yeejoin.amos.boot.module.**.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper" })
@ComponentScan(basePackages = { "org.typroject", "com.yeejoin.amos" })
public class AmosCylinderApplication {
	private static final Logger logger = LoggerFactory.getLogger(AmosCylinderApplication.class);
	@Autowired
	private EmqKeeper emqKeeper;
	@Autowired
	private FillingRecordSyncListener fillingRecordSyncListener;

	@Value("${spring.application.name}")
	private String applicationName;


	public static void main(String[] args) throws UnknownHostException {
		ConfigurableApplicationContext context = SpringApplication.run(AmosCylinderApplication.class, args);
		Environment env = context.getEnvironment();
		String ip = InetAddress.getLocalHost().getHostAddress();
		String port = env.getProperty("server.port");
		String path = oConvertUtils.getString(env.getProperty("server.servlet.context-path"));

		logger.info("\n----------------------------------------------------------\n\t"
				+ "Application Amos-Biz-Boot is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
				+ path + "/doc.html\n" + "----------------------------------------------------------");
	}

	/**
	 * 初始化MQTT
	 * 
	 * @throws MqttException
	 */
	@Bean
	public void initMqtt() throws Exception {
		emqKeeper.subscript(buildShareTopic(), 2, fillingRecordSyncListener);
	}

	/**
	 *  构建共享主题，分布式部署时，不会重复收到消息
	 * @return 共享主题
	 */
	private String buildShareTopic(){
		// 发布者主题为 / 开头，与共享主题冲突，所以再多加一根斜线
		return "$share/" + applicationName + "//tzs/sync/fillingRecord";
	}

//	@Bean
//	public void initToken() {
//		startPlatformTokenService.getToken();
//	}
}
