package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.TaskMessageDto;
import com.yeejoin.amos.boot.module.jg.api.dto.TaskModelDto;
import com.yeejoin.amos.boot.module.jg.api.dto.WorkflowResultDto;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.EquipTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.*;
import com.yeejoin.amos.boot.module.jg.api.service.IJgChangeRegistrationReformService;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationReformDto;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.ICmWorkflowService;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.*;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 改造变更登记服务实现类
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Service
public class JgChangeRegistrationReformServiceImpl extends BaseService<JgChangeRegistrationReformDto, JgChangeRegistrationReform, JgChangeRegistrationReformMapper> implements IJgChangeRegistrationReformService {
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    CommonServiceImpl commonServiceImpl;
    @Autowired
    ICmWorkflowService iCmWorkflowService;
    @Autowired
    private IdxBizJgUseInfoServiceImpl idxBizJgUseInfoService;
    @Autowired
    private IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;
    @Autowired
    private IdxBizJgFactoryInfoServiceImpl idxBizJgFactoryInfoService;
    @Autowired
    private OtherInfoMapper otherInfoMapper;
    //改造登记关系表mapper
    @Autowired
    private JgChangeRegistrationReformEqMapper jgChangeRegistrationReformEqMapper;
    //移装登记关系表
    @Autowired
    private JgChangeRegistrationTransferEqMapper jgChangeRegistrationTransferEqMapper;
    @Autowired
    private IdxBizJgTechParamsElevatorMapper idxBizJgTechParamsElevatorMapper;
    @Autowired
    private JgRegistrationHistoryMapper jgRegistrationHistoryMapper;
    //使用登记关系表mapper
    @Autowired
    private JgUseRegistrationEqMapper jgUseRegistrationEqMapper;
    @Autowired
    private IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;
    //单位变更登记关系表mapper
    @Autowired
    private JgChangeRegistrationUnitEqMapper jgChangeRegistrationUnitEqMapper;
    //更名变更登记关系表mapper
    @Autowired
    private JgChangeRegistrationNameEqMapper jgChangeRegistrationNameEqMapper;

    @Autowired
    private CommonMapper commonMapper;

    /**
     * 分页查询
     */
    public Page<Map<String, Object>> getList(JgChangeRegistrationReformDto dto, Page<Map<String, Object>> page, List<String> roleIds) {
        Page<Map<String, Object>> listPage = this.baseMapper.getListPage(page, dto, roleIds);
        return listPage;
    }

    public Page<Map<String, Object>> getEquipList(Page<Map<String, Object>> page, String factoryNum, String equList, String equCategory) {
        return this.baseMapper.getEquipListPage(page, factoryNum, equList, equCategory);
    }

    @Transactional
    public JgChangeRegistrationReform save(JSONObject map) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        UseInfo useInfo = new UseInfo();
        String equipId = map.get("record").toString();
        LambdaQueryWrapper<UseInfo> lambda = new QueryWrapper<UseInfo>().lambda();
        lambda.eq(UseInfo::getRecord, equipId);
        // 使用登记信息
        JgChangeRegistrationReform jgChangeRegistrationReform = new JgChangeRegistrationReform();
        LambdaQueryWrapper<OtherInfo> otherLambda = new QueryWrapper<OtherInfo>().lambda();
        otherLambda.eq(OtherInfo::getRecord, equipId);
        OtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
        String supervisoryCode = otherInfo.getSupervisoryCode();
        jgChangeRegistrationReform.setSupervisoryCode(supervisoryCode);
        jgChangeRegistrationReform.setUseUnitName(ObjectUtils.isEmpty(useInfo.getUseUnitName()) ? reginParams.getCompany().getCompanyName() : useInfo.getUseUnitName());
        jgChangeRegistrationReform.setUseUnitCreditCode(ObjectUtils.isEmpty(useInfo.getUseUnitCreditCode()) ? reginParams.getCompany().getCompanyCode() : useInfo.getUseUnitCreditCode());

        if (!ObjectUtils.isEmpty(map.get("transformationQualityCertificate"))) {
            jgChangeRegistrationReform.setTransformationQualityCertificate(JSONObject.toJSONString(map.get("transformationQualityCertificate")));
        }
        if (!ObjectUtils.isEmpty(map.get("renovationSupervisioninspectionCertificate"))) {
            jgChangeRegistrationReform.setRenovationSupervisioninspectionCertificate(JSONObject.toJSONString(map.get("renovationSupervisioninspectionCertificate")));
        }
        // 使用单位提交
        jgChangeRegistrationReform.setUseUnitCreditCode(reginParams.getCompany().getCompanyCode());
        if (!ObjectUtils.isEmpty(map.get("inspectUnitCreditCode"))) {
            jgChangeRegistrationReform.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
        } else {
            jgChangeRegistrationReform.setInspectUnitCreditCode(reginParams.getCompany().getCompanyCode());
        }
        if (!ObjectUtils.isEmpty(map.get("inspectOrgName"))) {
            jgChangeRegistrationReform.setInspectUnitName(map.get("inspectOrgName").toString());
        } else {
            jgChangeRegistrationReform.setInspectUnitName(reginParams.getCompany().getCompanyName());
        }
        if (map.containsKey("receiveCompanyCode")) {
            String receiveCompanyCode = String.valueOf(map.getString("receiveCompanyCode"));
            jgChangeRegistrationReform.setReceiveCompanyCode(receiveCompanyCode);
            jgChangeRegistrationReform.setReceiveOrgCode(receiveCompanyCode.split("_")[0]);
            jgChangeRegistrationReform.setReceiveOrgName(receiveCompanyCode.split("_")[1]);

        } else {
            jgChangeRegistrationReform.setReceiveCompanyCode("610000");
        }
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        //使用登记编号
        jgRegistrationHistory.setUseRegistrationCode(idxBizJgRegisterInfoMapper.getUseOrgCodeByEquip(equipId));
        //登记类别
        jgRegistrationHistory.setRegistrationClass("改造登记");
        //设备id
        jgRegistrationHistory.setEquId(equipId);
        //修改数据
        jgRegistrationHistory.setChangeData(JSONObject.toJSONString(map));
        //保存历史数据
        IdxBizJgTechParamsElevator idxBizJgTechParamsElevator = idxBizJgTechParamsElevatorMapper.selectOne(new QueryWrapper<IdxBizJgTechParamsElevator>().eq("RECORD", equipId));
        jgRegistrationHistory.setOldData(JSONObject.toJSONString(idxBizJgTechParamsElevator));
        //设备监管码
        jgRegistrationHistory.setSupervisoryCode(supervisoryCode);
        //数据状态
        jgChangeRegistrationReform.setUseRegistrationCode(jgRegistrationHistory.getUseRegistrationCode());
        String equipListName = this.getBaseMapper().getEquiplistNameByEquiplist(Optional.ofNullable(map.get("equList").toString()).orElse(" "));
        jgChangeRegistrationReform.setEquipListName(equipListName);
        jgChangeRegistrationReform.setCreateUserId(reginParams.getUserModel().getUserId());
        jgChangeRegistrationReform.setCreateUserName(reginParams.getUserModel().getRealName());
        jgChangeRegistrationReform.setCreateUserCompanyName(reginParams.getCompany().getCompanyName());
        jgRegistrationHistory.setStatus("new");
        if (map.containsKey("type") && "edit".equals(String.valueOf(map.get("type")))) {
            jgChangeRegistrationReform.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
            this.getBaseMapper().updateById(jgChangeRegistrationReform);
            jgChangeRegistrationReform = this.getBaseMapper().selectById(jgChangeRegistrationReform.getSequenceNbr());
            jgRegistrationHistory.setSequenceNbr(jgRegistrationHistoryMapper.getSequenceNbrByEquidAndDocumentId(equipId, String.valueOf(map.get("applyNo"))));
            jgRegistrationHistoryMapper.updateById(jgRegistrationHistory);
        } else {
            //暂存处理
            // 业务管理设备信息保存
            JgChangeRegistrationReformEq jgChangeRegistrationReformEq = new JgChangeRegistrationReformEq();
            jgChangeRegistrationReformEq.setEquId(equipId);
            ResponseModel<List<String>> result = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.GZBG.getCode(), 1);
            if (!result.getResult().isEmpty()) {
                jgChangeRegistrationReform.setApplyNo(result.getResult().get(0));
            } else {
                throw new BadRequest("申请单编号生成失败,请稍后重试!");
            }
            jgChangeRegistrationReform.setRegDate(new Date());
            jgChangeRegistrationReform.setStatus(WorkFlowStatusEnum.CHANGE_SUBMIT.getPass());
            jgChangeRegistrationReform.setAuditStatus(WorkFlowStatusEnum.CHANGE_SUBMIT.getPass());
            this.save(jgChangeRegistrationReform);
            jgChangeRegistrationReformEq.setEquipTransferId(jgChangeRegistrationReform.getSequenceNbr().toString());
            jgChangeRegistrationReformEqMapper.insert(jgChangeRegistrationReformEq);
            //当前单据id
            jgRegistrationHistory.setCurrentDocumentId(jgChangeRegistrationReform.getApplyNo());
            jgRegistrationHistoryMapper.insert(jgRegistrationHistory);
            //暂存时生成待办数据
            List<TaskModelDto> taskModelDtoList = Arrays.asList(getTaskModelDtoList(jgChangeRegistrationReform, null));
            commonServiceImpl.buildTaskModel(taskModelDtoList);

        }

        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            String instanceId = "";
            if (!ObjectUtils.isEmpty(jgChangeRegistrationReform.getSequenceNbr()) && !ObjectUtils.isEmpty(jgChangeRegistrationReform.getInstanceId())) {
                // 如果是旧流程则执行一步
                flowExecute(jgChangeRegistrationReform.getSequenceNbr(), jgChangeRegistrationReform.getInstanceId(), "0", "");
//                updateExecuteIds(instanceId, jgChangeRegistrationReform.getSequenceNbr(), "0");
            } else {
                // 如果是新启动的流程开启自动访问
                jgChangeRegistrationReform.setAuditStatus(WorkFlowStatusEnum.CHANGE_RECEIVE.getPass());
                jgChangeRegistrationReform.setStatus(WorkFlowStatusEnum.CHANGE_RECEIVE.getPass());
                ProcessTaskDTO processTaskDTO = startByVariable(jgChangeRegistrationReform);
                updateExecuteIds(instanceId, jgChangeRegistrationReform, "startWorkfow", processTaskDTO);
                List<TaskModelDto> taskModelDtoList = Arrays.asList(getTaskModelDtoList(jgChangeRegistrationReform, processTaskDTO));
                //启动之前删除暂存生成的待办
                commonServiceImpl.deleteTaskModel(String.valueOf(jgChangeRegistrationReform.getSequenceNbr()));
                //重新生成新的待办数据
                commonServiceImpl.buildTaskModel(taskModelDtoList);
            }


//            if (!ObjectUtils.isEmpty(instanceId)) {
//                // 执行流程
//                flowExecute(jgChangeRegistrationReform.getSequenceNbr(), instanceId, "0", "");
//                updateExecuteIds(instanceId, jgChangeRegistrationReform.getSequenceNbr(), "0");
//            }
        }
        return jgChangeRegistrationReform;
    }

    public ProcessTaskDTO startByVariable(JgChangeRegistrationReform jgChangeRegistrationReform) {
        ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
        //启动流程
        ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
        dto.setProcessDefinitionKey("renovationRegistrationReviewNew");
        dto.setBusinessKey("submit");
        dto.setCompleteFirstTask(Boolean.TRUE);
        dto.setNextExecuteUserCompanyCode(jgChangeRegistrationReform.getReceiveOrgCode());
        List<ActWorkflowStartDTO> actWorkflowStartDTOList = Arrays.asList(dto);
        ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
        actWorkflowBatchDTO.setProcess(actWorkflowStartDTOList);
        List<ProcessTaskDTO> result = iCmWorkflowService.startBatch(actWorkflowBatchDTO);
        if (!result.isEmpty()) {
            processTaskDTO = result.get(0);
        }
        return processTaskDTO;
    }

    public void updateExecuteIds(String instanceId, JgChangeRegistrationReform jgChangeRegistrationReform, String operate, ProcessTaskDTO processTaskDTO) {
        Boolean updateTodoAndCreate = Boolean.TRUE;
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        WorkflowResultDto workflowResultDto = conveterProcessTaskDTO2WorkflowResultDto(processTaskDTO);
        jgChangeRegistrationReform.setNextExecutorIds(workflowResultDto.getNextExecutorRoleIds());
        jgChangeRegistrationReform.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
        String nextTaskid = Optional.ofNullable(workflowResultDto.getNextTaskId()).orElse("");
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        if (!ObjectUtils.isEmpty(workflowResultDto.getNextTaskCode())) {
            taskCode = Optional.ofNullable(workflowResultDto.getNextTaskCode()).orElse("");
        }
        String role = Optional.ofNullable(workflowResultDto.getNextExecutorRoleIds()).orElse("");
        if (operate.equals("startWorkfow")) {
            role = Optional.ofNullable(workflowResultDto.getExecutorRoleIds()).orElse("") + "," + Optional.ofNullable(workflowResultDto.getNextExecutorRoleIds()).orElse("");
            operate = "0";
            instanceId = workflowResultDto.getInstanceId();
            updateTodoAndCreate = Boolean.FALSE;
        }
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            jgChangeRegistrationReform.setNextTaskId(nextTaskid);
            jgChangeRegistrationReform.setNextExecutorIds(role);
            jgChangeRegistrationReform.setPromoter(reginParams.getUserModel().getUserId());
            jgChangeRegistrationReform.setInstanceId(instanceId);
            if (!ObjectUtils.isEmpty(jgChangeRegistrationReform.getInstanceStatus())) {
                jgChangeRegistrationReform.setInstanceStatus(jgChangeRegistrationReform.getInstanceStatus() + "," + role);
            } else {
                jgChangeRegistrationReform.setInstanceStatus(role);
            }
            if ("0".equals(operate)) {
                // 通过操作
                jgChangeRegistrationReform.setAuditStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
                jgChangeRegistrationReform.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                jgChangeRegistrationReform.setAuditStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgChangeRegistrationReform.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgChangeRegistrationReform.setPromoter("");
            }
            if (updateTodoAndCreate) {
                // 上个代办改为已办
                HashMap<String, Object> map = new HashMap<>();
                if ("0".equals(operate)) {
                    map.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
                    map.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
                } else {
                    map.put("taskStatus", FlowStatusEnum.REJECTED.getCode());
                    map.put("taskStatusLabel", FlowStatusEnum.REJECTED.getName());
                }
                map.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgChangeRegistrationReform.getStatus()));
                map.put("flowStatusLabel", jgChangeRegistrationReform.getStatus());
                map.put("relationId", jgChangeRegistrationReform.getInstanceId());
                TaskV2Model taskV2Model = commonServiceImpl.updateTaskModel(map);
                TaskModelDto taskModelDto = new TaskModelDto();
                BeanUtils.copyProperties(taskV2Model, taskModelDto);
                taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                if (WorkFlowStatusEnum.CHANGE_SUBMIT.getCode().equals(taskCode) && "1".equals(operate)) {
                    taskModelDto.setPageType("edit");
                }
                // 创建新的代办
                taskModelDto.setModel(conveterTaskMessageDTO(jgChangeRegistrationReform));
                commonServiceImpl.buildTaskModel(Collections.singletonList(taskModelDto));
            }
        } else {
            jgChangeRegistrationReform.setAuditPassDate(new Date());
            jgChangeRegistrationReform.setAuditStatus(FlowStatusEnum.TO_BE_FINISHED.getName());
            jgChangeRegistrationReform.setStatus(FlowStatusEnum.TO_BE_FINISHED.getName());
            JgChangeRegistrationReformEq jgChangeRegistrationReformEq = jgChangeRegistrationReformEqMapper.selectOne(new QueryWrapper<JgChangeRegistrationReformEq>().eq("equip_transfer_id", jgChangeRegistrationReform.getSequenceNbr()));
            String newUseRegistrationCertificateNumber = getCode(jgChangeRegistrationReform.getSupervisoryCode());
            jgChangeRegistrationReform.setUseRegistrationCode(newUseRegistrationCertificateNumber);
            updateTechparamsByEquIdAndCurrentDoucumentId(jgChangeRegistrationReformEq.getEquId(), jgChangeRegistrationReform.getSequenceNbr().toString(), newUseRegistrationCertificateNumber, jgChangeRegistrationReform.getApplyNo());
            HashMap<String, Object> map = new HashMap<>();
            map.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
            map.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
            map.put("flowStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
            map.put("flowStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
            map.put("relationId", jgChangeRegistrationReform.getInstanceId());
            jgChangeRegistrationReform.setNextExecuteUserIds("");
            map.put("model", conveterTaskMessageDTO(jgChangeRegistrationReform));
            commonServiceImpl.updateTaskModel(map);
        }
        this.getBaseMapper().updateById(jgChangeRegistrationReform);
    }

    public void flowExecute(Long id, String instanceId, String operate, String comment) {
        ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
        JgChangeRegistrationReform jgChangeRegistrationReform = this.getBaseMapper().selectById(id);
        String taskId = jgChangeRegistrationReform.getNextTaskId();
        //组装信息
        TaskResultDTO dto = new TaskResultDTO();
        dto.setResultCode("approvalStatus");
        dto.setTaskId(taskId);
        dto.setComment(comment);
        HashMap<String, Object> map = new HashMap<>();
        map.put("approvalStatus", operate);
        //2023年12月27日16点33分 流程状态为起草人撤回或者一级审批驳回时需要将提交时的已同意修改为已提交
        if (!ObjectUtils.isEmpty(jgChangeRegistrationReform) && (jgChangeRegistrationReform.getStatus().equals(WorkFlowStatusEnum.CHANGE_SUBMIT.getRollBack()) || jgChangeRegistrationReform.getStatus().equals(WorkFlowStatusEnum.CHANGE_SUBMIT.getReject()))) {
            map.put("approvalStatus", "提交");
        }
        dto.setVariable(map);
        dto.setNextExecuteUserCompanyCode(getNextUserOrgCode(operate, jgChangeRegistrationReform));
        //执行流程
        processTaskDTO = iCmWorkflowService.complete(taskId, dto);
        // 更新下一步执行人
        updateExecuteIds(instanceId, jgChangeRegistrationReform, operate, processTaskDTO);

    }

    public void withdraw(String instanceId) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        JgChangeRegistrationReform jgChangeRegistrationReform = this.getBaseMapper().selectOne(new QueryWrapper<JgChangeRegistrationReform>().eq("instance_id", instanceId));
        ProcessTaskDTO processTaskDTO = iCmWorkflowService.rollBack(instanceId);
        WorkflowResultDto workflowResultDto = conveterProcessTaskDTO2WorkflowResultDto(processTaskDTO);
        String taskCode = Optional.ofNullable(workflowResultDto.getNextTaskCode()).orElse("");
        String role = Optional.ofNullable(workflowResultDto.getNextExecutorRoleIds()).orElse("");
        if (!ObjectUtils.isEmpty(taskCode)) {
            jgChangeRegistrationReform.setAuditStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
            jgChangeRegistrationReform.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
        }
        jgChangeRegistrationReform.setPromoter(reginParams.getUserModel().getUserId());
        jgChangeRegistrationReform.setNextTaskId(workflowResultDto.getNextTaskId());
        jgChangeRegistrationReform.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
        jgChangeRegistrationReform.setNextExecutorIds(role);
        this.getBaseMapper().updateById(jgChangeRegistrationReform);
//        commonServiceImpl.deleteTaskModel(instanceId);
        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(jgChangeRegistrationReform));
        jsonObject.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgChangeRegistrationReform.getAuditStatus()));
        jsonObject.put("flowStatusLabel", jgChangeRegistrationReform.getAuditStatus());
        jsonObject.put("nextTaskId", jgChangeRegistrationReform.getNextTaskId());
        jsonObject.put("nextExecuteUser", jgChangeRegistrationReform.getNextExecutorIds());
        jsonObject.put("taskType", BusinessTypeEnum.JG_RENOVATION_REGISTRATION.getCode());
        jsonObject.put("pageType", "look");
        //如果创建人等于当前人则打开编辑页面
        if (taskCode.equals(WorkFlowStatusEnum.CHANGE_SUBMIT.getCode())) {
            jsonObject.put("pageType", "edit");
        }
        jsonObject.put("model", conveterTaskMessageDTO(jgChangeRegistrationReform));
        commonServiceImpl.rollbackTask(instanceId, jsonObject);
    }

    public void deleteBatch(List<Long> ids) {
        List<JgChangeRegistrationReform> jgChangeRegistrationReformList = this.getBaseMapper().selectList(new QueryWrapper<JgChangeRegistrationReform>().in("sequence_nbr", ids));
        List<String> applyNos = jgChangeRegistrationReformList.stream().map(JgChangeRegistrationReform::getApplyNo).collect(Collectors.toList());
        JgChangeRegistrationReform jgChangeRegistrationReform = new JgChangeRegistrationReform();
        jgChangeRegistrationReform.setIsDelete(true);
        LambdaQueryWrapper<JgChangeRegistrationReform> lambda = new QueryWrapper<JgChangeRegistrationReform>().lambda();
        lambda.in(JgChangeRegistrationReform::getSequenceNbr, ids);
        this.getBaseMapper().delete(lambda);
        JgChangeRegistrationReformEq jgChangeRegistrationReformEq = new JgChangeRegistrationReformEq();
        jgChangeRegistrationReformEq.setIsDelete(true);
        LambdaQueryWrapper<JgChangeRegistrationReformEq> lambda1 = new QueryWrapper<JgChangeRegistrationReformEq>().lambda();
        lambda1.in(JgChangeRegistrationReformEq::getEquipTransferId, ids);
        jgChangeRegistrationReformEqMapper.delete(lambda1);
        jgRegistrationHistoryMapper.delete(new QueryWrapper<JgRegistrationHistory>().in("current_document_id", applyNos));
    }

    public Map<String, Object> getDetail(String currentDocumentId, String equipId) {
        JgChangeRegistrationReform jgChangeRegistrationReform = this.getBaseMapper().selectById(currentDocumentId);
        if (ObjectUtils.isEmpty(equipId)) {
            equipId = jgChangeRegistrationReformEqMapper.selectEquipId(currentDocumentId);
        }
        Map<String, Object> detail = new HashMap<>();
        Map<String, Object> originalData = new HashMap<>();
        Map<String, Object> originalDataOther = new HashMap<>();

        if ((jgChangeRegistrationReform.getStatus().equals("已完成") || jgChangeRegistrationReform.getStatus().equals("流程结束"))) {
            originalData = idxBizJgRegisterInfoService.getDetailByRecord(equipId);
            originalDataOther = idxBizJgRegisterInfoService.getDetailFieldCamelCaseByRecord(equipId);
            detail.putAll(originalDataOther);
            detail.put("techInfo", originalData);
        } else {
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryMapper.selectOne(new QueryWrapper<JgRegistrationHistory>()
                    .eq("equ_id", equipId)
                    .eq("current_document_id", jgChangeRegistrationReform.getApplyNo())
                    .eq("registration_class", "改造登记"));
            originalData = JSONObject.parseObject(jgRegistrationHistory.getChangeData(), Map.class);
            detail.putAll(originalData);
        }
        detail.putAll(JSONObject.parseObject(JSONObject.toJSONString(jgChangeRegistrationReform), Map.class));
        if (!ObjectUtils.isEmpty(detail.get("transformationQualityCertificate"))) {
            detail.put("transformationQualityCertificate", JSONObject.parse(detail.get("transformationQualityCertificate").toString()));
        }
        if (!ObjectUtils.isEmpty(detail.get("renovationSupervisioninspectionCertificate"))) {
            detail.put("renovationSupervisioninspectionCertificate", JSONObject.parse(detail.get("renovationSupervisioninspectionCertificate").toString()));
        }
        return detail;
    }


    /**
     * 批量设置设备无效(使用登记、移装登记、改造登记)
     *
     * @param equipmentId       装备id
     * @param currentDocumentId 当前文档id
     */
    public void makeEquipmentsInvalid(String equipmentId, String currentDocumentId) {
        jgChangeRegistrationReformEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        jgChangeRegistrationTransferEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        jgUseRegistrationEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        //单位变更登记
        jgChangeRegistrationUnitEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        //更名变更登记
        jgChangeRegistrationNameEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
    }

    /**
     * 流程完成之后互换数据并更新设备状态
     *
     * @param equipId
     * @param currentDocumentId
     */
    public void updateTechparamsByEquIdAndCurrentDoucumentId(String equipId, String currentDocumentId, String newUseRegistrationCertificateNumber, String applyNo) {

        IdxBizJgTechParamsElevator idxBizJgTechParamsElevator = idxBizJgTechParamsElevatorMapper.selectOne(new QueryWrapper<IdxBizJgTechParamsElevator>().eq("RECORD", equipId));
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryMapper.selectOne(new QueryWrapper<JgRegistrationHistory>()
                .eq("equ_id", equipId)
                .eq("current_document_id", applyNo)
                .eq("registration_class", "改造登记"));

        if (!ObjectUtils.isEmpty(idxBizJgTechParamsElevator) && !ObjectUtils.isEmpty(jgRegistrationHistory)) {
            //历史数据
            String historyData = JSONObject.toJSONString(idxBizJgTechParamsElevator);
            //当前数据
            String newData = jgRegistrationHistory.getChangeData();
            //将历史数据更新到技术参数表中
            JSONObject allData = JSONObject.parseObject(newData);
            Map<String, Object> techInfo = (Map<String, Object>) allData.get("techInfo");
            IdxBizJgTechParamsElevator idxBizJgTechParamsElevatorNew = JSONObject.parseObject(JSONObject.toJSONString(techInfo), IdxBizJgTechParamsElevator.class);
            BeanUtil.copyProperties(idxBizJgTechParamsElevatorNew, idxBizJgTechParamsElevator, "sequenceNbr", "record");
            idxBizJgTechParamsElevatorMapper.updateById(idxBizJgTechParamsElevator);
            //将历史数据回填到历史记录表中
            jgRegistrationHistory.setChangeData(newData);
            jgRegistrationHistory.setOldData(historyData);
            jgRegistrationHistory.setStatus("history");
            jgRegistrationHistoryMapper.updateById(jgRegistrationHistory);
            makeEquipmentsInvalid(equipId, currentDocumentId);
            //更新使用注册登记证编号
            idxBizJgRegisterInfoMapper.updateUseOrgCodeByEquip(equipId, newUseRegistrationCertificateNumber);
            //es中的编号信息
            Map<String, Map<String, Object>> resultMap = new HashMap<>();
            Map<String, Object> map1 = new HashMap<>();
            map1.put("USE_ORG_CODE", newUseRegistrationCertificateNumber);
            resultMap.put(equipId, map1);
            tzsServiceFeignClient.commonUpdateEsDataByIds(resultMap);
        }
    }

    /*
     * 获取电梯的原始技术参数
     * @param equipId
     */
    public Map<String, Object> getOriginalTechParams(String equipId) {
        Map<String, Object> result = new HashMap<>();
        IdxBizJgTechParamsElevator idxBizJgTechParamsElevator = idxBizJgTechParamsElevatorMapper.selectOne(new QueryWrapper<IdxBizJgTechParamsElevator>().eq("RECORD", equipId));
        if (!ObjectUtils.isEmpty(idxBizJgTechParamsElevator)) {
            result = JSONObject.parseObject(JSONObject.toJSONString(idxBizJgTechParamsElevator), Map.class);
            result.remove("sequenceNbr");
        }
        return result;
    }

    /**
     * 参数为监管码
     *
     * @param supervisoryCode
     * @return
     */
    public String getCode(String supervisoryCode) {
        if (!ObjectUtils.isEmpty(supervisoryCode) && supervisoryCode.length() > 5) {
            String name = EquipTypeEnum.getMessage(supervisoryCode.substring(1, 2));
            String type = supervisoryCode.substring(2, 4);
            String city = supervisoryCode.substring(0, 1);
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(name + type + "陕" + city);
            return stringResponseModel.getResult();
        }
        return null;
    }

    @Override
    public void exportUseRegistrationCertificate(String sequenceNbr, HttpServletResponse response) {
        Map<String, Object> exportParamsMap = new HashMap<>();
        //查询移装变更详情
        JgChangeRegistrationReform jgChangeRegistrationReform = this.getById(sequenceNbr);
        JgChangeRegistrationReformEq jgChangeRegistrationReformEq = jgChangeRegistrationReformEqMapper.selectOne(new QueryWrapper<JgChangeRegistrationReformEq>().eq("equip_transfer_id", sequenceNbr));
        if (ValidationUtil.isEmpty(jgChangeRegistrationReform) || ValidationUtil.isEmpty(jgChangeRegistrationReformEq)) {
            throw new BadRequest("使用登记证导出失败,请稍后重试!");
        }
        //是否废弃
        exportParamsMap.put("isInvalid", jgChangeRegistrationReformEq.getIsInvalid());
        if (ValidationUtil.isEmpty(jgChangeRegistrationReform.getReceiveOrgName())) {
            throw new BadRequest("使用登记证导出失败,登记机关为空!");
        }
        exportParamsMap.put("receiveOrgName", jgChangeRegistrationReform.getReceiveOrgName());
        //使用登记证编号
        if (ValidationUtil.isEmpty(jgChangeRegistrationReform.getUseRegistrationCode())) {
            throw new BadRequest("使用登记证导出失败,使用登记证编号为空!");
        }
        exportParamsMap.put("useRegistrationCode", jgChangeRegistrationReform.getUseRegistrationCode());
        //使用单位名称
        if (ValidationUtil.isEmpty(jgChangeRegistrationReform.getUseUnitName())) {
            throw new BadRequest("使用登记证导出失败,使用单位名称为空!");
        }
        exportParamsMap.put("useUnitName", jgChangeRegistrationReform.getUseUnitName());
        //监管码
        if (ValidationUtil.isEmpty(jgChangeRegistrationReform.getSupervisoryCode())) {
            throw new BadRequest("使用登记证导出失败,监管码为空!");
        }
        exportParamsMap.put("supervisoryCode", jgChangeRegistrationReform.getSupervisoryCode());
        //发证日期（当前时间）
        LocalDate today = LocalDate.now();
        exportParamsMap.put("giveOutYear", today.getYear());
        exportParamsMap.put("giveOutMonth", today.getMonthValue());
        exportParamsMap.put("giveOutDay", today.getDayOfMonth());

        //查询设备注册信息
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new QueryWrapper<IdxBizJgRegisterInfo>().eq("RECORD", jgChangeRegistrationReformEq.getEquId()));
        if (!ValidationUtil.isEmpty(registerInfo)) {
            //设备种类、类别、品种
            String equList = registerInfo.getEquList();//设备种类
            String equCategory = registerInfo.getEquCategory();//设备类别
            String equDefine = registerInfo.getEquDefine();//设备品种
            List<EquipmentCategory> categoryList0 = commonServiceImpl.getEquipmentCategoryList(equList, null);
            List<EquipmentCategory> categoryList1 = commonServiceImpl.getEquipmentCategoryList(equCategory, null);
            List<EquipmentCategory> categoryList2 = commonServiceImpl.getEquipmentCategoryList(equDefine, null);
            if (CollectionUtils.isNotEmpty(categoryList0)) {
                if (ValidationUtil.isEmpty(categoryList0.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备种类为空!");
                }
                exportParamsMap.put("equList", categoryList0.get(0).getName());
            }
            if (CollectionUtils.isNotEmpty(categoryList1)) {
                if (ValidationUtil.isEmpty(categoryList1.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备类别为空!");
                }
                exportParamsMap.put("equCategory", categoryList1.get(0).getName());
            }
            if (CollectionUtils.isNotEmpty(categoryList2)) {
                if (ValidationUtil.isEmpty(categoryList2.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备品种为空!");
                }
                exportParamsMap.put("equDefine", categoryList2.get(0).getName());
            }
            //设备代码
            if (ValidationUtil.isEmpty(registerInfo.getEquCode())) {
                throw new BadRequest("使用登记证导出失败,设备代码为空!");
            }
            exportParamsMap.put("equCode", registerInfo.getEquCode());
        }

        //单位内部编码
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(jgChangeRegistrationReformEq.getEquId());
        if (!ValidationUtil.isEmpty(useInfo)) {
            if (ValidationUtil.isEmpty(useInfo.getUseInnerCode())) {
                throw new BadRequest("使用登记证导出失败,设备单位内部编码为空!");
            }
            exportParamsMap.put("useInnerCode", useInfo.getUseInnerCode());

            String fullAddress = "";
            String province = useInfo.getProvinceName();
            String city = useInfo.getCityName();
            String county = useInfo.getCountyName();
            String street = useInfo.getStreetName();
            String address = useInfo.getAddress();
            if (!ObjectUtils.isEmpty(province)) {
                fullAddress += province;
            }
            if (!ObjectUtils.isEmpty(city)) {
                fullAddress += city;
            }
            if (!ObjectUtils.isEmpty(county)) {
                fullAddress += county;
            }
            if (!ObjectUtils.isEmpty(street)) {
                fullAddress += street;
            }
            if (!ObjectUtils.isEmpty(address)) {
                fullAddress += address;
            }
            if (ValidationUtil.isEmpty(fullAddress)) {
                throw new BadRequest("使用登记证导出失败,设备使用地址为空!");
            }
            exportParamsMap.put("fullAddress", fullAddress);
        }
        IdxBizJgFactoryInfo factoryInfo = idxBizJgFactoryInfoService.getOneData(jgChangeRegistrationReformEq.getEquId());
        //产品编号(出厂编号)
        if (!ValidationUtil.isEmpty(factoryInfo)) {
            if (ValidationUtil.isEmpty(factoryInfo.getFactoryNum())) {
                throw new BadRequest("使用登记证导出失败,产品编号为空!");
            }
            exportParamsMap.put("factoryNum", factoryInfo.getFactoryNum());
        }
        //调用生成使用登记证
        commonServiceImpl.generateCertificateReport(exportParamsMap, response);
    }

    /**
     * @return String
     * @deprecated 动态获取
     */
    public String getSummaryInfo(JgChangeRegistrationReform jgChangeRegistrationReform) {
        String result = "来自%s【%s】的业务办理，【申请单号：%s】";
        return String.format(result, Optional.ofNullable(jgChangeRegistrationReform.getEquipListName()).orElse("无"), jgChangeRegistrationReform.getSupervisoryCode(), jgChangeRegistrationReform.getApplyNo());
    }

    /**
     * 构建工作台待办实体类
     *
     * @param jgChangeRegistrationReform
     * @param processTaskDTO
     * @return
     */
    public TaskModelDto getTaskModelDtoList(JgChangeRegistrationReform jgChangeRegistrationReform, ProcessTaskDTO processTaskDTO) {
        //设置实体无需字段为空
        TaskModelDto taskModelDto = new TaskModelDto();
        if (ObjectUtils.isEmpty(processTaskDTO)) {

            //taskCode 使用申请单编号
            taskModelDto.setTaskCode(jgChangeRegistrationReform.getApplyNo());
            //摘要
            taskModelDto.setTaskContent(getSummaryInfo(jgChangeRegistrationReform));
            //任务类型
            taskModelDto.setTaskType(BusinessTypeEnum.JG_RENOVATION_REGISTRATION.getCode());
            //工作流实例id
            taskModelDto.setRelationId(String.valueOf(jgChangeRegistrationReform.getSequenceNbr()));
            taskModelDto.setModel(conveterTaskMessageDTO(jgChangeRegistrationReform));
        } else {
            List<WorkflowResultDto> workflowResultDtoList = commonServiceImpl.buildWorkFlowInfo(Arrays.asList(processTaskDTO));
            WorkflowResultDto workflowResultDto = conveterProcessTaskDTO2WorkflowResultDto(processTaskDTO);
            //工作流创建时间
            taskModelDto.setFlowCreateDate(jgChangeRegistrationReform.getCreateDate());
            //工作流返回节点名称
            taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
            //taskCode 使用申请单编号
            taskModelDto.setTaskCode(jgChangeRegistrationReform.getApplyNo());
            //摘要
            taskModelDto.setTaskContent(getSummaryInfo(jgChangeRegistrationReform));
            //任务描述-非必填
            taskModelDto.setTaskDesc(null);
            //任务类型
            taskModelDto.setTaskType(BusinessTypeEnum.JG_RENOVATION_REGISTRATION.getCode());
            //任务类型名称
            taskModelDto.setTaskTypeLabel(BusinessTypeEnum.JG_RENOVATION_REGISTRATION.getName());
            //工作流实例id
            taskModelDto.setRelationId(jgChangeRegistrationReform.getInstanceId());
            //执行人id
            taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
            //任务状态code
            taskModelDto.setTaskStatus(commonServiceImpl.getDictionaryCodeByName(jgChangeRegistrationReform.getStatus()));
            taskModelDto.setFlowStatus(taskModelDto.getTaskStatus());
            //任务状态名称
            taskModelDto.setTaskStatusLabel(jgChangeRegistrationReform.getStatus());
            taskModelDto.setFlowStatusLabel(jgChangeRegistrationReform.getStatus());
            //任务创建人id
            taskModelDto.setStartUserId(jgChangeRegistrationReform.getCreateUserId());
            //任务创建人名称
            taskModelDto.setStartUser(jgChangeRegistrationReform.getCreateUserName());
            //任务发起人所在单位
            taskModelDto.setStartUserCompanyName(jgChangeRegistrationReform.getCreateUserCompanyName());
            //任务发起人发起时间
            taskModelDto.setStartDate(new Date());
            taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
            //跳转路径
//        taskModelDto.setRoutePath();
            taskModelDto.setModel(conveterTaskMessageDTO(jgChangeRegistrationReform));
        }
        return taskModelDto;
    }

    /**
     * 将processTaskDTO转换成WorkflowResultDto
     *
     * @param processTaskDTO
     * @return
     */
    public WorkflowResultDto conveterProcessTaskDTO2WorkflowResultDto(ProcessTaskDTO processTaskDTO) {
        List<WorkflowResultDto> workflowResultDtoList = commonServiceImpl.buildWorkFlowInfo(Arrays.asList(processTaskDTO));
        WorkflowResultDto workflowResultDto = new WorkflowResultDto();
        if (!workflowResultDtoList.isEmpty()) {
            workflowResultDto = workflowResultDtoList.get(0);
        }
        return workflowResultDto;
    }

    /**
     * 将jgChangeRegistrationReform转换成TaskModelDto
     *
     * @param jgChangeRegistrationReform
     * @return
     */
    public TaskMessageDto conveterTaskMessageDTO(JgChangeRegistrationReform jgChangeRegistrationReform) {
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        taskMessageDto.setInstanceId(jgChangeRegistrationReform.getInstanceId());
        taskMessageDto.setStatus(jgChangeRegistrationReform.getStatus());
        taskMessageDto.setAuditStatus(jgChangeRegistrationReform.getStatus());
        taskMessageDto.setPromoter(jgChangeRegistrationReform.getPromoter());
        taskMessageDto.setNextExecuteUserIds(jgChangeRegistrationReform.getNextExecuteUserIds());
        taskMessageDto.setSequenceNbr(jgChangeRegistrationReform.getSequenceNbr());
        taskMessageDto.setNextExecuteIds(jgChangeRegistrationReform.getNextExecutorIds());
        return taskMessageDto;
    }


    private String getNextUserOrgCode(String operate, JgChangeRegistrationReform jgChangeRegistrationReform) {
        if ("0".equals(operate)) {
            // 执行通过节点，单位code为接收机构单位信息
            return jgChangeRegistrationReform.getReceiveOrgCode();
        }
        if (jgChangeRegistrationReform.getAuditStatus().equals(WorkFlowStatusEnum.CHANGE_RECEIVE.getPass())
                || jgChangeRegistrationReform.getAuditStatus().equals(WorkFlowStatusEnum.CHANGE_RECEIVE.getReject())
                || jgChangeRegistrationReform.getAuditStatus().equals(WorkFlowStatusEnum.CHANGE_RECEIVE.getRollBack())) {
            // 驳回且当前节点为一键节点时，单位code为发起人单位信息
            return jgChangeRegistrationReform.getUseUnitCreditCode();
        }
        // 2、3级驳回时，单位code为接收单位code
        return jgChangeRegistrationReform.getReceiveOrgCode();
    }
}