package com.yeejoin.amos.api.householdapi.face.service.business;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFInverterTotalGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFInverterYearGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdHYGFInverterYearGenerateMapper;
import com.yeejoin.amos.api.householdapi.face.service.AscriptionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2024/4/9
 */
@Service
public class TdHYGFInverterYearGenerateImpl  implements AscriptionService {
    @Autowired
    private JpStationMapper jpStationMapper;
    @Autowired
    private TdHYGFInverterYearGenerateMapper tdHYGFInverterYearGenerateMapper;
    @Override
    public void updateAscription(String timeNum) {
        try {
            DateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
            DateFormat dfty = new SimpleDateFormat("yyyy");

            Date star = dft.parse(timeNum);//开始时间
            String yearMonth=   dfty.format(star);
            List<TdHYGFInverterYearGenerate> hygfjpDayPower = tdHYGFInverterYearGenerateMapper.selectList(
                    new QueryWrapper<TdHYGFInverterYearGenerate>().
                            eq("year", yearMonth).and(wrapper -> {
                        wrapper.isNull("regional_companies_code")
                                .or()
                                .isNull("amos_company_code")
                                .or()
                                .isNull("station_name")
                                .or()
                                .isNull("station_state");
                    })
            );

            if(hygfjpDayPower!=null&&!hygfjpDayPower.isEmpty()){
                for (TdHYGFInverterYearGenerate dayPower : hygfjpDayPower) {
                    JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().
                            eq("third_station_id", dayPower.getThirdStationId()));
                    dayPower.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                    dayPower.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                    dayPower.setStationName(jpStation.getName());
                    dayPower.setStationState(jpStation.getState());
                    tdHYGFInverterYearGenerateMapper.insert(dayPower);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}