package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 整改单状态枚举
 */
@Getter
@AllArgsConstructor
@SuppressWarnings("ALL")
public enum RectificationStatusEnum {

    待整改("待整改", 1),

    整改未完成("整改未完成", 2),

    整改已完成("整改已完成", 3);


    /**
     * 名称，描述
     */
    private final String name;
    /**
     * 编码
     */
    private final int code;

    public static RectificationStatusEnum getNodeByCode(int code) {
        RectificationStatusEnum anEnum = null;
        for (RectificationStatusEnum type : RectificationStatusEnum.values()) {
            if (type.getCode() == code) {
                anEnum = type;
                break;
            }
        }
        return anEnum;
    }
}
