package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.CommerceInfoDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.CommerceInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 经销商单位信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@RestController
@Api(tags = "经销商单位信息Api")
@RequestMapping(value = "/commerce-info")
public class CommerceInfoController extends BaseController {

    @Autowired
    CommerceInfoServiceImpl commerceInfoServiceImpl;

    /**
     * 新增经销商单位信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增经销商单位信息", notes = "新增经销商单位信息")
	public ResponseModel<CommerceInfoDto> save(@RequestBody CommerceInfoDto model) {
	    model = commerceInfoServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新经销商单位信息", notes = "根据sequenceNbr更新经销商单位信息")
	public ResponseModel<CommerceInfoDto> updateBySequenceNbrCommerceInfo(@RequestBody CommerceInfoDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(commerceInfoServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除经销商单位信息", notes = "根据sequenceNbr删除经销商单位信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(commerceInfoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个经销商单位信息",  notes = "根据sequenceNbr查询单个经销商单位信息")
	public ResponseModel<CommerceInfoDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(commerceInfoServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "经销商单位信息分页查询",  notes = "经销商单位信息分页查询")
	public ResponseModel<Page<CommerceInfoDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CommerceInfoDto> page = new Page<CommerceInfoDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(commerceInfoServiceImpl.queryForCommerceInfoPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "经销商单位信息列表全部数据查询",   notes = "经销商单位信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CommerceInfoDto>> selectForList() {
	    return ResponseHelper.buildResponse(commerceInfoServiceImpl.queryForCommerceInfoList());
	}
}
