package com.yeejoin.amos.boot.module.das;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;


import java.net.InetAddress;


/**
 * <pre>
 * 智信能源科技服务启动类
 * </pre>
 *
 * @author DELL
 */
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableAsync
@EnableScheduling
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class, DruidDataSourceAutoConfigure.class})
@MapperScan({"com.yeejoin.amos.boot.module.das.mapper.msyql","com.yeejoin.amos.boot.module.das.mapper.tdengineanalysis","com.yeejoin.amos.boot.module.das.mapper.tdengineiot"})
@ComponentScan({"springfox.documentation.schema", "com.yeejoin.amos.boot.module.das"})
public class AmosJxiopDasApplication {



	private static final Logger logger = LoggerFactory.getLogger(AmosJxiopDasApplication.class);

	public static void main(String[] args) throws Exception {
		ConfigurableApplicationContext context = SpringApplication.run(AmosJxiopDasApplication.class, args);
		Environment env = context.getEnvironment();
		String ip = InetAddress.getLocalHost().getHostAddress();
		String port = env.getProperty("server.port");
		String path = env.getProperty("server.servlet.context-path") == null ? "" : env.getProperty("server.servlet.context-path");

		logger.info("\n----------------------------------------------------------\n\t"
				+ "Application Amos-Biz-Boot-Jxiop-Montior is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
				+ path + "/doc.html\n" + "----------------------------------------------------------");
	}

}
