package com.yeejoin.amos.boot.module.das.config;


import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;
import java.sql.SQLException;

/**
 * 从数据源配置
 * 若需要配置更多数据源 , 直接在yml中添加数据源配置再增加相应的新的数据源配置类即可
 */
@Configuration
@MapperScan(basePackages = "com.yeejoin.amos.boot.module.das.mapper.tdengineanalysis", sqlSessionFactoryRef = "taosSqlSessionFactory")
public class TdEngineConfig {
    private Logger logger = LoggerFactory.getLogger(TdEngineConfig.class);
    // 精确到 cluster 目录，以便跟其他数据源隔离
    private static final String MAPPER_LOCATION = "classpath*:mapper/*.xml";


    @Value("${spring.db3.datasource.url}")
    private String dbUrl;

    @Value("${spring.db3.datasource.username}")
    private String username;

    @Value("${spring.db3.datasource.password}")
    private String password;

    @Value("${spring.db3.datasource.driver-class-name}")
    private String driverClassName;


    @Bean(name = "taosDataSource")   //声明其为Bean实例
    public DataSource clusterDataSource() {
        DruidDataSource datasource = new DruidDataSource();

        datasource.setUrl(this.dbUrl);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setDriverClassName(driverClassName);
        datasource.setInitialSize(100); // 初始连接数
        datasource.setMaxActive(200); // 最大连接数
        datasource.setMaxWait(60000); // 最大等待时间
        datasource.setMinIdle(5); // 最小空闲连接数
        datasource.setValidationQuery("SELECT 1"); // 验证查询
        try {
            datasource.setFilters("stat");
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        datasource.setQueryTimeout(30); // 查询超时时间
        datasource.setConnectionProperties("useUnicode=true;characterEncoding=UTF-8"); // 连接属性
        return datasource;
    }

    @Bean(name = "taosTransactionManager")
    public DataSourceTransactionManager clusterTransactionManager() {
        return new DataSourceTransactionManager(clusterDataSource());
    }

    @Bean(name = "taosSqlSessionFactory")
    public SqlSessionFactory clusterSqlSessionFactory(@Qualifier("taosDataSource") DataSource culsterDataSource)
            throws Exception {
        final MybatisSqlSessionFactoryBean sessionFactory = new MybatisSqlSessionFactoryBean();
        sessionFactory.setDataSource(culsterDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
                .getResources(MAPPER_LOCATION));
        sessionFactory.setTypeAliasesPackage("com.yeejoin.amos.boot.module.das.entity");
        //mybatis 数据库字段与实体类属性驼峰映射配置
        sessionFactory.getObject().getConfiguration().setMapUnderscoreToCamelCase(true);
        return sessionFactory.getObject();
    }
}

