package com.yeejoin.amos.boot.module.das.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 *
 * @author system_generator
 * @date 2023-10-24
 */
@Data
@Accessors(chain = true)
@TableName("iot_front_gateway_device_points")
public class FrontGatewayDevicePoints implements Serializable {

    private static final long serialVersionUID = 1L;


    @TableId(value = "SEQUENCE_NBR" , type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    @TableField("REC_DATE" )
    protected Date recDate;

    @TableField("REC_USER_ID" )
    protected String recUserId;


    /**
     * 测点名称
     */
	@TableField("POINT_NAME")
    private String pointName;

    /**
     * 测点类型（装置测点，合成测点）
     */
	@TableField("POINT_TYPE")
    private String pointType;

    /**
     * 测点值数据类型（遥测，遥信，遥脉）
     */
	@TableField("POINT_DATA_TYPE")
    private String pointDataType;

    /**
     * 测点描述
     */
	@TableField("POINT_DESC")
    private String pointDesc;

    /**
     * 公式
     */
	@TableField("POINT_FORMULA")
    private String pointFormula;

    /**
     * 地址
     */
	@TableField("POINT_ADDRESS")
    private String pointAddress;

    /**
     * 网关设备ID
     */
	@TableField("POINT_DEVICE_ID")
    private Long pointDeviceId;

    /**
     * 测点位置
     */
	@TableField("POINT_LOCATION")
    private String pointLocation;

    @TableField ("POINT_LOCATION_CODE")
    private String pointLocationCode;
    /**
     * 关联设备ID,多个用逗号隔开
     */
	@TableField("DEVICE_ID")
    private String deviceId;

    @TableField(exist=false)
    private String deviceName;

    /**
     * 网关ID
     */
	@TableField("GATEWAY_ID")
    private Long gatewayId;

    @TableField("POINT_RESOURCE_ID")
    private Long pointResourceId;

    @TableField ("GROUP_ID")
    private Long groupId;

    /**
     * 数据类型遥信等对应的枚举
     */
    @TableField ("DATA_TYPE")
    private String dataType;

  /**
   * 采样周期
   */
  @TableField("SAMPLING_PERIOD")
  private String samplingPeriod;
}
