package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.dto.BadManangerDto;
import com.yeejoin.precontrol.common.dto.FileDto;
import com.yeejoin.precontrol.common.dto.JobDisclosureDto;
import com.yeejoin.precontrol.common.dto.TaskPaycheckDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 作业活动Vo
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class TaskVo {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long id;
    @ApiModelProperty(value = "所属项目id")
    private Long projectId;
    @ApiModelProperty(value = "项目名称")
    private String projectName;
    @ApiModelProperty(value = "作业类型")
    private Long type;
    @ApiModelProperty(value = "发起人id")
    private Long createPersonId;
    @ApiModelProperty(value = "发起人姓名")
    private String createPersonName;
    @ApiModelProperty(value = "任务状态")
    private Long status;
    @ApiModelProperty(value = "任务状态名称")
    private String statusName;
    @ApiModelProperty(value = "任务单号")
    private String taskNo;
    @ApiModelProperty(value = "文件")
    @ImagePrefix
    private List<FileDto> file;
    @ApiModelProperty(value = "作业交底")
    private JobDisclosureDto jobDisclosure;
    @ApiModelProperty(value = "三交三查数据")
    @ImagePrefix
    private TaskPaycheckDto taskPaycheck;
    @ApiModelProperty(value = "违规管理")
    private BadManangerDto badMananger;
    @ApiModelProperty(value = "二维码")
    private byte[] qrCode;
    @ApiModelProperty(value = "创建时间")
    private Date createDate;
    @ApiModelProperty(value = "docHtml内容")
    private List<String> docContent;


    @ApiModelProperty(value = "未完成任务的当前状态")
    private Long currentStatus;
    @ApiModelProperty(value = "风险作业确认状态")
    private Long riskStatus;
    @ApiModelProperty(value = "施工人员确认状态")
    private Long builderStatus;
}
