package com.yeejoin.amos.boot.module.elevator.biz.controller;


import cn.hutool.core.util.ObjectUtil;
import com.yeejoin.amos.boot.biz.common.annotation.ResubmitCheck;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertFormRecordDto;
import com.yeejoin.amos.boot.module.elevator.api.service.IAlertFormRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * 警情接警修改记录Api
 */
@RestController
@Api(tags = "警情接警修改记录Api")
@RequestMapping(value = "/alert-update")
public class AlertFormRecordController {

    @Autowired
    private IAlertFormRecordService iAlertFormRecordService;


    @ResubmitCheck
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/saveRecord")
    @ApiOperation(httpMethod = "POST", value = "新增警情接警填报记录", notes = "新增警情接警填报记录")
    public ResponseModel<Object> saveRecord(@RequestBody AlertFormRecordDto record) {
        return ResponseHelper.buildResponse(iAlertFormRecordService.saveAlertFormRecord(record));
    }

    @ResubmitCheck
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/recordByCalledId")
    @ApiOperation(httpMethod = "POST", value = "根据警情id查询修改记录", notes = "根据警情id查询修改记录")
    public ResponseModel<Object> recordByCalledId(@RequestBody Map<String, String> map) {
        return ResponseHelper.buildResponse(iAlertFormRecordService.allAlertFormRecordByCalledId(Long.valueOf(map.get("alertCalledId"))));
    }

}
