package com.yeejoin.amos.boot.module.elevator.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.elevator.api.dto.KV;
import com.yeejoin.amos.boot.module.elevator.api.dto.MsgLogDto;
import com.yeejoin.amos.boot.module.elevator.biz.service.impl.MsgLogServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 消息流水表
 *
 * @author system_generator
 * @date 2022-04-20
 */
@RestController
@Api(tags = "消息流水表Api")
@RequestMapping(value = "/msg-log")
public class MsgLogController extends BaseController {

    @Autowired
    MsgLogServiceImpl msgLogServiceImpl;

    /**
     * 新增消息流水表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增消息流水表", notes = "新增消息流水表")
    public ResponseModel<MsgLogDto> save(@RequestBody MsgLogDto model) {
        model = msgLogServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新消息流水表", notes = "根据sequenceNbr更新消息流水表")
    public ResponseModel<MsgLogDto> updateBySequenceNbrMsgLog(@RequestBody MsgLogDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(msgLogServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除消息流水表", notes = "根据sequenceNbr删除消息流水表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(msgLogServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个消息流水表", notes = "根据sequenceNbr查询单个消息流水表")
    public ResponseModel<MsgLogDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(msgLogServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "消息流水表分页查询", notes = "消息流水表分页查询")
    public ResponseModel<Page<MsgLogDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam(value = "size") int size) {
        Page<MsgLogDto> page = new Page<MsgLogDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(msgLogServiceImpl.queryForMsgLogPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消息流水表列表全部数据查询", notes = "消息流水表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<MsgLogDto>> selectForList() {
        return ResponseHelper.buildResponse(msgLogServiceImpl.queryForMsgLogList());
    }

    /**
     * 告警数量统计
     *
     * @return Integer
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "告警数量统计", notes = "告警数量统计")
    @GetMapping(value = "/count")
    public ResponseModel<Integer> countByTerminalType(@RequestParam(value = "terminalType", required = false) String terminalType) {
        return ResponseHelper.buildResponse(msgLogServiceImpl.countByTerminalType(terminalType));
    }

    /**
     * 列表分页查询
     *
     * @param current      当前页
     * @param size         每页大小
     * @param terminalType 终端类型
     * @param isRead       是否未读
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page/terminalType")
    @ApiOperation(httpMethod = "GET", value = "消息流水表分页查询", notes = "消息流水表分页查询")
    public ResponseModel<Page<MsgLogDto>> queryForPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(required = false) String terminalType,
            @RequestParam(required = false) Boolean isRead,
            @RequestParam(required = false) String sendTimeStart,
            @RequestParam(required = false) String sendTimeEnd,
            @RequestParam(required = false) String msgType,
            @RequestParam(required = false) String body
    ) {
        Page<MsgLogDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(msgLogServiceImpl.queryForMsgLogByTerminalTypePage(page, terminalType, isRead, sendTimeStart, sendTimeEnd, msgType, body));
    }

    /**
     * 获取消息类型
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/msgType")
    @ApiOperation(httpMethod = "GET", value = "获取消息类型")
    public ResponseModel<List<KV>> queryForPage() {
        return ResponseHelper.buildResponse(msgLogServiceImpl.getType());
    }

    /**
     * 全部已读
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/allRead")
    @ApiOperation(httpMethod = "GET", value = "全部已读")
    public ResponseModel<Boolean> allRead() {
        return ResponseHelper.buildResponse(msgLogServiceImpl.allRead());
    }

    /**
     * 批量删除
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteByIds")
    @ApiOperation(httpMethod = "POST", value = "批量删除")
    public ResponseModel<Boolean> deleteByIds(@RequestBody Map<String, List<Long>> body) {
        return ResponseHelper.buildResponse(msgLogServiceImpl.deleteByIds(body.get("ids")));
    }
}
