package com.yeejoin.amos.boot.module.tcm.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tcm.api.dto.EquEnterDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.tcm.api.vo.SortVo;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业数据信息 Mapper 接口
 *
 * @author duanwei
 * @date 2022-08-10
 */
public interface TzBaseEnterpriseInfoMapper extends BaseMapper<TzBaseEnterpriseInfo> {

	/**
	 * 查找企业关联设备详情列表
	 * 
	 * @param sequenceNbr 企业id
	 * @return EquEnterDto 使用登记证代码、设备名称、设备类别、设备位置
	 */
	List<EquEnterDto> getInfo(String sequenceNbr);

	/**
	 * 根据企业名称查找设备
	 *
	 * @param useUnit 企业名称
	 * @return
	 */
	List<EquEnterDto> getInfoByUseUnit(String useUnit);

	/**
	 * 根据企业名称查找企业详情信息
	 * @param useUnit
	 * @return
	 */
	TzBaseEnterpriseInfo selectByUseUnit(String useUnit);


	CompanyModel getOneByCompanyCode(String companyCode);


	IPage<TzBaseEnterpriseInfoDto> page(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto);

	IPage<TzBaseEnterpriseInfoDto> pageList(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto, List orgCodeList, @Param("sort") SortVo sortMap);

	/**
	 * 查询未生成二维码的企业
	 * @return
	 */
    List<TzBaseEnterpriseInfo> listNoQrCode();

	List<Map<String, Object>> getEquipType(@Param("type")String type);

    Map<String, Object> getProblemInfoBySourceId(@Param("sourceId")String sourceId);

	/**
	 * 批量更新企业单位orgCode
	 * @param superviseOrgName 新监管单位名称
	 * @param oldSuperviseOrgCode 旧监管单位orgCode
	 * @param preSuperviseOrgCode 新监管单位orgCode
	 * @param oldOrgCode 企业旧orgCode
	 * @param preOrgCode 企业新orgCode
	 * @param sequenceNbr 企业表id
	 */
	void updateSubCompanyOrgCode(@Param("superviseOrgName") String superviseOrgName, @Param("oldSuperviseOrgCode") String oldSuperviseOrgCode, @Param("preSuperviseOrgCode")  String preSuperviseOrgCode,
								 @Param("oldOrgCode") String oldOrgCode, @Param("preOrgCode")  String preOrgCode, @Param("sequenceNbr") Long sequenceNbr);

	/**
	 * 用企业新orgCode替换各个表缓存orgCode
	 * 企业信息
	 * 	tz_base_enterprise_info：org_code、
	 * 人员信息
	 * 	cb_org_usr：amos_org_code
	 * 两个规定
	 * 	p_static_day、p_static_week、p_static_month：org_code
	 * 	p_check、p_check_input、p_check_shot：org_code
	 * 	p_plan：user_dept
	 * 	p_plan_task：org_code、user_dept
	 * 监管业务
	 * 	tzs_feedback_suggestions：supervise_org_code
	 *
	 * @param oldOrgCode 单位旧orgCode
	 * @param newOrgCode 单位新orgCode
	 */
    void updateUnitOrgCode(@Param("oldOrgCode") String oldOrgCode, @Param("newOrgCode") String newOrgCode, @Param("useCode") String useCode);

	List<String> selectEquipmentBySupervisionOrgCode(String oldOrgCode);

	List<String> selectCompanyBySupervisionOrgCode(String oldOrgCode);

	void updateRedundantSupervisionOrgCodeUnit(String newOrgName, String newOrgCode, String oldOrgCode);

	void updateRedundantSupervisionOrgCodeStatistics(String newOrgCode, String oldOrgCode);

	void updateEquipmentSupervisionOrgCode(String newOrgCode, String newSupervisionName, List<String> equipmentList);
}
