package com.yeejoin.amos.boot.module.jxiop.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.yeejoin.amos.boot.biz.common.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.biz.common.excel.ExplicitConstraint;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.Date;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/4/24
 */
@Data
@ApiModel(value = "EXPersonUser", description = "")
public class EXPersonUser {

    @ExcelProperty(value = "姓名", index = 0)
    @ApiModelProperty(value = "姓名")
    private String name;
    @ExcelProperty(value = "工号", index = 1)
    @ApiModelProperty(value = "工号")
    private String jobNumber;
    @ExcelProperty(value = "所属场站", index = 2)
    @ApiModelProperty(value = "所属场站")
    private String projectName;
    @ExcelIgnore
    @ApiModelProperty(value = "部门")
    private String departmentName;
    @ExcelProperty(value = "证件类型", index = 3)
    @ApiModelProperty(value = "证件类型(0-身份证)")
    private String idType;
    @ExcelProperty(value = "证件编号", index = 4)
    @ApiModelProperty(value = "证件编号")
    private String idNumber;
    @ExcelProperty(value = "平台账号名称", index = 5)
    @ApiModelProperty(value = "平台账号名称")
    private String accountName;




    @ExplicitConstraint(indexNum = 6, source = {"男","女"}) //固定下拉内容
    @ExcelProperty(value = "性别", index = 6)
    @ApiModelProperty(value = "性别( 0-男 1-女 )")
    private String sex;

    @ExcelProperty(value = "生日", index = 7)
    @ApiModelProperty(value = "生日")
    private Date birthday;

    @ExcelProperty(value = "年龄", index = 8)
    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ExcelIgnore
    @ApiModelProperty(value = "籍贯")
    private String nativePlace;

    @ExcelProperty(value = "民族", index = 9)
    @ExplicitConstraint(indexNum = 9, sourceClass = CommonExplicitConstraint.class,type="MZ") //固定下拉内容
    @ApiModelProperty(value = "民族")
    private String folkKey;

    @ExcelProperty(value = "政治面貌", index =10)
    @ExplicitConstraint(indexNum = 10,  source = {"群众","共青团员","预备党员","中共党员"}) //固定下拉内容
    @ApiModelProperty(value = "政治面貌")
    private String politicCountenance;

    @ExcelProperty(value = "户籍地址", index = 11)
    @ApiModelProperty(value = "户籍地址")
    private String registeredResidenceAddress;

    @ExcelProperty(value = "现住址", index = 12)
    @ApiModelProperty(value = "现住址")
    private String presentAddress;

    @ExcelProperty(value = "应急电话", index = 13)
    @ApiModelProperty(value = "应急电话")
    private String emergencyPhone;

    @ExcelProperty(value = "电话", index = 14)
    @ApiModelProperty(value = "电话")
    private String phone;

    @ExcelProperty(value = "身高（厘米）", index = 15)
    @ApiModelProperty(value = "身高（厘米）")
    private Integer height;

    @ExcelProperty(value = "体重（千克）", index = 16)
    @ApiModelProperty(value = "体重（千克）")
    private Integer weight;

    @ExcelProperty(value = "参加工作时间", index = 17)
    @ApiModelProperty(value = "参加工作时间")
    private Date workTime;

    @ExcelProperty(value = "进入本单位工作时间", index = 18)
    @ApiModelProperty(value = "进入本单位工作时间")
    private Date stationWorkTime;

    @ExcelProperty(value = "工作所在地", index = 19)
    @ExplicitConstraint(indexNum = 19,  source = {"国内","国外"}) //固定下拉内容
    @ApiModelProperty(value = "工作所在地key")
    private String workPlaceKey;

    @ExcelProperty(value = "岗位", index = 20)
    @ExplicitConstraint(indexNum = 20,sourceClass = CommonExplicitConstraint.class,type="YGZYJNJDZS") //固定下拉内容
    @ApiModelProperty(value = "岗位")
    private String postName;

    @ExcelProperty(value = "是否特殊工种", index = 21)
    @ExplicitConstraint(indexNum = 21,  source = {"是","否"}) //固定下拉内容
    @ApiModelProperty(value = "是否特殊工种")
    private String isSpecialWork;

    @ExcelProperty(value = "技能鉴定工种", index = 22)
    @ExplicitConstraint(indexNum = 22, sourceClass = CommonExplicitConstraint.class,type="JNDDGZ") //固定下拉内容
    @ApiModelProperty(value = "技能鉴定工种key")
    private String workTypeKey;

    @ExcelProperty(value = "工种名称", index = 23)
    @ExplicitConstraint(indexNum = 23, sourceClass = CommonExplicitConstraint.class,type="JNJDGZ") //固定下拉内容
    @ApiModelProperty(value = "工种名称")
    private String workName;

    @ExcelProperty(value = "专业技术资格名称", index = 24)
    @ExplicitConstraint(indexNum = 24, sourceClass = CommonExplicitConstraint.class,type="ZYJSZGMC") //固定下拉内容
    @ApiModelProperty(value = "专业技术资格名称")
    private String professionalTechnologyName;

    @ExcelProperty(value = "技能等级", index = 25)
    @ExplicitConstraint(indexNum = 25, source = {"无","初级工","中级工","高级工","技师","高级技师","其他"}) //固定下拉内容
    @ApiModelProperty(value = "技能等级key")
    private String skillLevelKey;

    @ExcelProperty(value = "专业技术资格等级", index = 26)
    @ExplicitConstraint(indexNum = 26, source = {"初级","中级","副高级","正高级","教授级"}) //固定下拉内容
    @ApiModelProperty(value = "专业技术资格等级")
    private String professionalTechnologyLevelKey;

    @ExcelProperty(value = "岗位执业鉴定证书", index = 27)
    @ApiModelProperty(value = "岗位执业鉴定证书")
    @ExplicitConstraint(indexNum = 27, sourceClass = CommonExplicitConstraint.class,type="POST_PRACTICE_CERTIFICATE") //固定下拉内容
    private String professionalQualificationCertificate;

    @ExcelProperty(value = "岗位职业鉴定证书", index = 28)
    @ApiModelProperty(value = " 岗位职业鉴定证书")
    @ExplicitConstraint(indexNum = 28, sourceClass = CommonExplicitConstraint.class,type="POST_OCCUPATION_CERTIFICATE") //固定下拉内容
    private String professionalCareerCertificate;

    @ExcelProperty(value = "初始学历", index = 29)
    @ApiModelProperty(value = "初始学历key")
    @ExplicitConstraint(indexNum = 29, sourceClass = CommonExplicitConstraint.class,type="CSXL") //固定下拉内容
    private String initialEducationKey;

    @ExcelProperty(value = "现学历", index = 30)
    @ExplicitConstraint(indexNum = 30, sourceClass = CommonExplicitConstraint.class,type="XXL") //固定下拉内容
    @ApiModelProperty(value = "现学历key")
    private String currentEducationKey;

    @ExcelProperty(value = "现学历学校名称", index = 31)
    @ApiModelProperty(value = "现学历学校名称")
    private String currentSchool;

    @ExcelProperty(value = "现学历所学专业", index = 32)
    @ApiModelProperty(value = "现学历所学专业")
    private String currentMajor;

    @ExcelProperty(value = "证件类型", index = 33)
    @ApiModelProperty(value = "证件类型")
    @ExplicitConstraint(indexNum = 33, sourceClass = CommonExplicitConstraint.class,type="ZDLX") //固定下拉内容
    private String documentType;

    @ExcelProperty(value = "证书名称", index = 34)
    @ApiModelProperty(value = "证书名称")
    @ExplicitConstraint(indexNum = 34, sourceClass = CommonExplicitConstraint.class,type="ZYJSZGMC") //固定下拉内容
    private String certificateName;

    @ExcelProperty(value = "取证时间", index = 35)
    @ApiModelProperty(value = "取证时间")
    private Date certificateTime;

    @ExcelProperty(value = "发证机关", index = 36)
    @ApiModelProperty(value = "发证机关")
    private String issuingAuthority;

    @ExcelProperty(value = "证书编号", index = 37)
    @ApiModelProperty(value = "证书编号")
    private String certificateNum;

    @ExcelProperty(value = "取证项目", index = 38)
    @ApiModelProperty(value = "取证项目")
    private String certificateProject;

    @ExcelProperty(value = "有效期限", index = 39)
    @ApiModelProperty(value = "有效期限")
    private String validPeriod;

    @ExcelProperty(value = "证书等级", index = 40)
    @ApiModelProperty(value = "证书等级")
    @ExplicitConstraint(indexNum = 40, source = {"初级","中级","高级"} ) //固定下拉内容
    private String certificateGrade;

}
