package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.yeejoin.amos.boot.module.tzs.api.common.MobileLoginParam;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.TzsAppService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@RestController
@Api(tags = "tzs小程序接口")
@RequestMapping(value = "/tzs-app")
public class TzsAppController {

    @Autowired
    TzsAppService appService;

    /**
     * 获取设计信息
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipmentInfo")
    @ApiOperation(httpMethod = "GET", value = "获取设计信息", notes = "获取设计信息")
    public ResponseModel<Object> getEquipmentInfo(String record) {
        return ResponseHelper.buildResponse(appService.getEquipmentInfo(record));
    }

    /**
     * 根据监管码查询设备详情
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getEquipInfoBySuperviseCode")
    @ApiOperation(httpMethod = "GET", value = "根据监管码查询设备详情", notes = "根据监管码查询设备详情")
    public ResponseModel<Object> getEquipInfoBySuperviseCode(String supervisoryCode) {
        return ResponseHelper.buildResponse(appService.getEquipInfoBySuperviseCode(supervisoryCode));
    }

    /**
     * 登录
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PostMapping(value = "/mobile/login")
    @ApiOperation(httpMethod = "POST", value = "小程序登录", notes = "小程序登录")
    public ResponseModel<Map<String, Object>> login(@RequestBody MobileLoginParam param) {
        return ResponseHelper.buildResponse(appService.login(param));
    }

}
