package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.yeejoin.amos.boot.biz.common.utils.QRCodeUtil;
import com.yeejoin.amos.boot.module.tzs.api.common.CommonException;
import com.yeejoin.amos.boot.module.tzs.api.common.MobileLoginParam;
import com.yeejoin.amos.boot.module.tzs.api.dto.*;
import com.yeejoin.amos.boot.module.tzs.api.entity.*;
import com.yeejoin.amos.boot.module.tzs.api.mapper.CategoryOtherInfoMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.RegUnitInfo;
import com.yeejoin.amos.boot.module.tzs.flc.api.mapper.RegUnitInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.IdPasswordAuthModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.*;

@Service
@Slf4j
public class TzsAppService {
    @Autowired
    DesignInfoService designInfoService;

    @Autowired
    ProduceInfoService produceInfoService;

    @Autowired
    ConstructionInfoService constructionInfoService;

    @Autowired
    RegistrationInfoService registrationInfoService;

    @Autowired
    EquipTechParamBoilerService boilerService;

    @Autowired
    EquipTechParamElevatorService elevatorService;

    @Autowired
    EquipTechParamLiftingService liftingService;

    @Autowired
    EquipTechParamPipelineService pipelineService;

    @Autowired
    EquipTechParamRidesService ridesService;

    @Autowired
    EquipTechParamRopewayService ropewayService;

    @Autowired
    EquipTechParamVehicleService vehicleService;

    @Autowired
    EquipTechParamVesselService vesselService;

    @Autowired
    MainPartsServiceImpl mainPartsService;

    @Autowired
    ProtectionDevicesServiceImpl protectionDevicesService;

    @Autowired
    UseInfoService unseInfoService;

    @Autowired
    MaintenanceInfoService maintenanceInfoService;

    @Autowired
    InspectionDetectionInfoServiceImpl inspectionDetectionInfoService;

    @Autowired
    OtherInfoService otherInfoService;

    @Autowired
    EquipmentCategoryServiceImpl equipmentCategoryServiceImpl;

    @Autowired
    CategoryOtherInfoMapper categoryOtherInfoMapper;

    @Value("${minio.url.path}")
    String minioPath;
    @Autowired
    private RegUnitInfoMapper regUnitInfoMapper;

    /**
     * 产品appkey
     */
    private static final String appKey="AMOS_STUDIO";
    /**
     * 产品product
     */
    private static final String product="AMOS_STUDIO_WEB";

    private final int successsCode = 200;

    public Map<String, Object> getEquipmentInfo(String record){
        Map<String, Object> map = new HashMap();
        map.put("SEQUENCE_NBR",record);
        map.put("tableName","idx_biz_view_jg_claim");
        List<Map<String, Object>> detialMapList = equipmentCategoryServiceImpl.getTable(map).getRecords();
        if (!ValidationUtil.isEmpty(detialMapList)){
            map = detialMapList.iterator().next();
        }
        map.putAll(getQRCode(record));

        JSONArray jsonArray = new JSONArray();
        // 出厂
        JSONObject exFactoryJsonObject = new JSONObject();
        List exFactoryList = new ArrayList();
        getGroupList(record, DesignInfo.class,DesignInfoModel.class, designInfoService, exFactoryList,false);
        getGroupList(record, ProduceInfo.class,ProduceInfoModel.class, produceInfoService, exFactoryList,false);
        exFactoryJsonObject.put("title","出厂");
        exFactoryJsonObject.put("tabValue",exFactoryList);
        jsonArray.add(exFactoryJsonObject);

        // 施工
        JSONObject constructionJsonObject = new JSONObject();
        List constructionList = new ArrayList();
        getGroupList(record, ConstructionInfo.class, ConstructionInfoModel.class, constructionInfoService, constructionList,true);
        constructionJsonObject.put("title","施工");
        constructionJsonObject.put("tabValue",constructionList);
        jsonArray.add(constructionJsonObject);

        // 注册
        JSONObject registrationJsonObject = new JSONObject();
        List registrationList = new ArrayList();
        getGroupList(record, RegistrationInfo.class, RegistrationInfoModel.class, registrationInfoService, registrationList,false);
        getGroupList(record, EquipTechParamBoiler.class, EquipTechParamBoilerModel.class, boilerService, registrationList,false);
        getGroupList(record, EquipTechParamElevator.class, EquipTechParamElevatorModel.class, elevatorService, registrationList,false);
        getGroupList(record, EquipTechParamLifting.class, EquipTechParamLiftingModel.class, elevatorService, registrationList,false);
        getGroupList(record, EquipTechParamPipeline.class, EquipTechParamPipelineModel.class, pipelineService, registrationList,false);
        getGroupList(record, EquipTechParamRides.class, EquipTechParamRidesModel.class, ridesService, registrationList,false);
        getGroupList(record, EquipTechParamRopeway.class, EquipTechParamRopewayModel.class, ropewayService, registrationList,false);
        getGroupList(record, EquipTechParamVehicle.class, EquipTechParamVehicleModel.class, vehicleService, registrationList,false);
        getGroupList(record, EquipTechParamVessel.class, EquipTechParamVesselModel.class, vesselService, registrationList,false);
        getGroupList(record, MainParts.class, MainPartsModel.class, mainPartsService, registrationList,false);
        getGroupList(record, ProtectionDevices.class, ProtectionDevicesModel.class, protectionDevicesService, registrationList,false);
        registrationJsonObject.put("title","注册");
        registrationJsonObject.put("tabValue",registrationList);
        jsonArray.add(registrationJsonObject);

        // 使用
        JSONObject useJsonObject = new JSONObject();
        List useList = new ArrayList();
        getGroupList(record, UseInfo.class, UseInfoModel.class, unseInfoService, useList,false);
        useJsonObject.put("title","使用");
        useJsonObject.put("tabValue",useList);
        jsonArray.add(useJsonObject);

        // 维保
        JSONObject maintenanceJsonObject = new JSONObject();
        List maintenanceList = new ArrayList();
        getGroupList(record, MaintenanceInfo.class, MaintenanceInfoModel.class, maintenanceInfoService, maintenanceList,true);
        maintenanceJsonObject.put("title","维保");
        maintenanceJsonObject.put("tabValue",maintenanceList);
        jsonArray.add(maintenanceJsonObject);

        // 检验
        JSONObject inspectionJsonObject = new JSONObject();
        List inspectionList = new ArrayList();
        getGroupList(record, InspectionDetectionInfo.class, InspectionDetectionInfoModel.class, inspectionDetectionInfoService, inspectionList,true);
        inspectionJsonObject.put("title","检验");
        inspectionJsonObject.put("tabValue",inspectionList);
        jsonArray.add(inspectionJsonObject);

        // 其他
        JSONObject otherJsonObject = new JSONObject();
        List otherList = new ArrayList();
        getGroupList(record, OtherInfo.class, OtherInfoModel.class, otherInfoService, otherList,false);
        otherJsonObject.put("title","其他");
        otherJsonObject.put("tabValue",otherList);
        jsonArray.add(otherJsonObject);
        map.put("tab",jsonArray);

        return map;
    }

    public void getGroupList(String record,Class entity, Class dto, BaseService service, List list, boolean isOne){
        TableInfoHelper.initTableInfo(new MapperBuilderAssistant(new MybatisConfiguration(), ""), entity);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("RECORD",record);
        if(isOne){
            wrapper.orderByDesc("REC_DATE");
        }

        List entityList = service.list(wrapper);
        Iterator iterator = entityList.iterator();
        if(!isOne) {
            while (iterator.hasNext()) {
                JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(iterator.next()));
                JSONObject result = getFieldList(dto, jsonObject,null);
                list.add(result);
            }
        } else {
            int count = entityList.size();
            JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(iterator.next()));
            JSONObject result = getFieldList(dto, jsonObject,count);
            list.add(result);
        }
    }


    public JSONObject getFieldList(Class clazz,JSONObject jsonObject,Integer count){
        JSONObject result = new JSONObject();
        JSONObject ApiModel = JSON.parseObject(JSON.toJSONString(clazz.getAnnotation(ApiModel.class)));
        String groupName = ApiModel.getString("description");
        Field[] declaredFields = clazz.getDeclaredFields();
        List<Map<String,Object>> list = new ArrayList<>();
        if(!ValidationUtil.isEmpty(declaredFields)){
            for (Field field : declaredFields) {
                if (field.getAnnotation(ApiModelProperty.class) != null && !ValidationUtil.isEmpty(field.getAnnotation(ApiModelProperty.class).value())) {
                    Map<String,Object> map = new HashMap<>();
                    String filedName = field.getAnnotation(ApiModelProperty.class).value();

                    // key和value可根据需求存
                    // 这存的key为注解的值，value为类属性名
                    map.put( "fieldName",filedName);
                    map.put("fieldValue",jsonObject.getString(field.getName()));
                    map.put("fieldKey",field.getName());
                    list.add(map);
                }
            }
        }

        // 整理出现多个附件的情况
        Iterator<Map<String,Object>> iterator = list.iterator();
        JSONArray array = new JSONArray();
        Boolean bool = true;
        String name = "";
        while (iterator.hasNext()) {
            Map<String,Object> map = iterator.next();
            String fieldName = map.get("fieldName").toString();
            if(fieldName.contains("附件")){
                if(bool){
                    // 第一个出现的附件名称为表单显示的名称
                    name = fieldName;
                    bool = false;
                }
                if(!ValidationUtil.isEmpty(map.get("fieldValue"))){
                    JSONArray jsonArray = JSON.parseArray(String.valueOf(map.get("fieldValue")));
                    JSONArray json = new JSONArray();
                    for(Object obj: jsonArray){
                        JSONObject object = JSON.parseObject(JSON.toJSONString(obj));
                        if(!ValidationUtil.isEmpty(object)){
                            object.getString("url");
                            object.put("url",minioPath+object.getString("url"));
                            json.add(object);
                        }
                    }
                    array.addAll(json);
                }
                // 删除所有附件
                iterator.remove();
            }
        }
        // 如果有附件 整理为一个附件 添加入list里
        if(!bool) {
            Map<String, Object> map = new HashMap<>();
            map.put("fieldKey", "files");
            map.put("fieldValue", array);
            map.put("fieldName", name);
            list.add(map);
        }

        if(!ValidationUtil.isEmpty(count)){
            result.put("groupCount",count);
        }

        result.put("groupName",ApiModel.getString("description"));
        result.put("groupKey",ApiModel.getString("value"));
        result.put("groupValue",list);
        return result;
    }

    /**
     * 获取焊口编号
     * @return
     */
    public JSONObject getQRCode(String code){
        String url = "";
        JSONObject jsonObject = new JSONObject();
        byte[] bytes = QRCodeUtil.generateQRCodeImageByteData(code,50);
        InputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            MultipartFile file = new MockMultipartFile(code+".jpg",code+".jpg", ContentType.APPLICATION_OCTET_STREAM.toString(), inputStream);
            FeignClientResult<Map<String, String>> date = Systemctl.fileStorageClient.updateCommonFileFree(file, "ugp/qrcode");
            if (date != null) {
                Map<String, String> map = date.getResult();
                Iterator<String> it = map.keySet().iterator();
                String urlString=it.next();
                jsonObject.put("fileUrl", minioPath+urlString);
                jsonObject.put("fileName", code);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public Object getEquipInfoBySuperviseCode(String supervisoryCode) {
        CategoryOtherInfo categoryOtherInfo = categoryOtherInfoMapper.selectOne(new QueryWrapper<CategoryOtherInfo>().eq("SUPERVISORY_CODE", supervisoryCode));
        return ObjectUtils.isEmpty(categoryOtherInfo) ? null : getEquipmentInfo(categoryOtherInfo.getRecord());
    }

    public Map<String, Object> login(MobileLoginParam param){
        
        Map<String, Object> result = new LinkedHashMap<>();
        IdPasswordAuthModel idPasswordAuthModel = new IdPasswordAuthModel();
        idPasswordAuthModel.setLoginId(param.getPhoneNo());
        idPasswordAuthModel.setPassword(param.getVerifyCode());
        FeignClientResult<Map<String, String>> idpassword = new FeignClientResult<>();
        RequestContext.setToken("");
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        try {
             idpassword = Privilege.authClient.idpassword(idPasswordAuthModel);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (idpassword.getStatus() != successsCode) {

            log.error("调用平台手机号验证码登录失败:{}", idpassword.getDevMessage());
            String message = idpassword.getMessage();
            if (StringUtils.isEmpty(message)) {
                message = "账号已被禁用,请联系管理员";
            }
            throw new CommonException(600001, message);
        }

        HashMap<Object, Object> authInfo = new HashMap<>();// 设置authInfo信息
        authInfo.put("token", idpassword.getResult().get("token"));
        authInfo.put("personId", idpassword.getResult().get("userId"));
        authInfo.put("appKey", appKey);
        authInfo.put("product", product);
        result.put("authInfo", authInfo);
        //业务查询
        RegUnitInfo userInfo = regUnitInfoMapper.userDataINfo(param.getPhoneNo(),param.getVerifyCode());
        result.put("userInfo", userInfo);
        return result;
    }


}
