package com.yeejoin.amos.maintenance.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the p_point_photo database table.
 * 
 */
@Entity
@Table(name="p_point_photo")
@NamedQuery(name="PointPhoto.findAll", query="SELECT p FROM PointPhoto p")
public class PointPhoto extends BasicEntity {
	private static final long serialVersionUID = 1L;

	/**
	 * 图片名称
	 */
	@Column(name="file_name")
	private String fileName;

	/**
	 * 序号
	 */
	@Column(name="order_no")
	private int orderNo;

	/**
	 * 权限系统org code
	 */
	@Column(name="org_code")
	private String orgCode;

	/**
	 * 图片路径
	 */
	@Column(name="photo_path")
	private String photoPath;

	/**
	 * 巡检点id
	 */
	@Column(name="point_id")
	private long pointId;

	public PointPhoto() {
	}

	public String getFileName() {
		return this.fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public int getOrderNo() {
		return this.orderNo;
	}

	public void setOrderNo(int orderNo) {
		this.orderNo = orderNo;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getPhotoPath() {
		return this.photoPath;
	}

	public void setPhotoPath(String photoPath) {
		this.photoPath = photoPath;
	}

	public long getPointId() {
		return this.pointId;
	}

	public void setPointId(long pointId) {
		this.pointId = pointId;
	}

}