package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.feign.IotFeignClient;
import com.yeejoin.amos.boot.module.jcs.api.dto.AircraftDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.AircraftListTreeDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.KeyValueLabel;
import com.yeejoin.amos.boot.module.jcs.api.entity.Aircraft;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.UserCar;
import com.yeejoin.amos.boot.module.jcs.api.enums.AircraftFileTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AircraftMapper;
import com.yeejoin.amos.boot.module.jcs.api.mapper.UserCarMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAircraftService;
import com.yeejoin.amos.boot.module.jcs.api.service.IUserCarService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.FileInfoModel;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.DataNotFound;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 航空器信息服务实现类
 *
 * @author system_generator
 * @date 2021-06-29
 */
@Service
public class UserCarServiceImpl extends BaseService<AircraftDto, UserCar, UserCarMapper> implements IUserCarService {

    @Autowired
    UserCarMapper UserCarMapper;
    @Override
    public UserCar selectByAmosUserId(Long id) {
        QueryWrapper<UserCar> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("amos_user_id", id);
        return UserCarMapper.selectOne(queryWrapper);
    }

    @Override
    public void add(UserCar userCar) {

        QueryWrapper<UserCar> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("amos_user_id", userCar.getAmosUserId());
        UserCar uer= UserCarMapper.selectOne(queryWrapper);
        if(uer!=null){
            userCar.setSequenceNbr(uer.getSequenceNbr());
            UserCarMapper.updateById(userCar);
        }else{
              UserCarMapper.insert(userCar);
        }
    }

    @Override
    public void delete(UserCar userCar) {
        QueryWrapper<UserCar> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("amos_user_id", userCar.getAmosUserId());
        UserCarMapper.delete(queryWrapper);
    }
}
