package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.jg.api.entity.SafetyProblemTracing;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemSourceTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.SafetyProblemTracingMapper;
import com.yeejoin.amos.boot.module.jg.api.dto.SafetyProblemTracingDto;
import com.yeejoin.amos.boot.module.jg.api.service.ISafetyProblemTracingService;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgRegisterInfoService;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.ValidationUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

import static org.springframework.jdbc.object.BatchSqlUpdate.DEFAULT_BATCH_SIZE;

/**
 * 安全追溯问题服务实现类
 *
 * @author system_generator
 * @date 2024-05-21
 */
@Service
public class SafetyProblemTracingServiceImpl extends BaseService<SafetyProblemTracingDto, SafetyProblemTracing, SafetyProblemTracingMapper> implements ISafetyProblemTracingService {

    @Autowired
    IIdxBizJgRegisterInfoService idxBizJgRegisterInfoService;
    @Autowired
    DataDictionaryServiceImpl iDataDictionaryService;

    private static Map<String, String> regionCodeOrgCodeMap = new ConcurrentHashMap<>();
    @Autowired
    CommonMapper commonMapper;

    /**
     * 分页查询
     */
    public Page<SafetyProblemTracingDto> queryForSafetyProblemTracingPage(Page<SafetyProblemTracingDto> page, SafetyProblemTracingDto problemModel) {
        return this.baseMapper.queryForSafetyProblemTracingPage(page, problemModel);
    }

    public Page<SafetyProblemTracingDto> getProblemRecords(Page<SafetyProblemTracingDto> page, SafetyProblemTracingDto problemModel) {
        String orgCode = getAndSetOrgCode(problemModel.getCityCode());
        if (ObjectUtils.isEmpty(orgCode)){
            return new Page<>();
        }
        problemModel.setGoverningBodyOrgCode(orgCode);
        // 使用orgCode过滤
        // 将单位类型从code转化为value
        if (!ValidationUtil.isEmpty(problemModel.getPrincipalUnitType())){
            Collection<DataDictionary> unitTypeList = iDataDictionaryService.list(new QueryWrapper<DataDictionary>()
                    .eq("type", "UNIT_TYPE_NEW")
                    .eq("is_delete", false)
                    .orderByAsc("sort_num"));
            Map<String, String> unitTypeMap = unitTypeList.stream().collect(Collectors.toMap(DataDictionary::getCode, DataDictionary::getName));
            problemModel.setPrincipalUnitType(unitTypeMap.getOrDefault(problemModel.getPrincipalUnitType(),null));
        }
        return this.baseMapper.queryForSafetyProblemTracingPage(page, problemModel);
    }

    public String getAndSetOrgCode(String cityCode) {
        String orgCode = regionCodeOrgCodeMap.get(cityCode);
        if (orgCode == null) {
            orgCode = commonMapper.getOrgCodeByCompanyCode(cityCode);
            if (orgCode != null) {
                regionCodeOrgCodeMap.put(cityCode, orgCode);
            }
        }
        return orgCode;
    }

    public Page<SafetyProblemTracingDto> queryProblemPageByEquipId(Page<SafetyProblemTracingDto> page, String equipId) {
        SafetyProblemTracingDto problemModel = new SafetyProblemTracingDto();
        problemModel.setSourceId(equipId);
        return this.baseMapper.queryForSafetyProblemTracingPage(page, problemModel);
    }

    /**
     * 根据ID查询
     */
    public SafetyProblemTracingDto selectOne(Long sequenceNbr) {
        SafetyProblemTracingDto entity = new SafetyProblemTracingDto();
        LambdaQueryWrapper<SafetyProblemTracing> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SafetyProblemTracing::getSequenceNbr, sequenceNbr);
        SafetyProblemTracing problem = this.baseMapper.selectOne(queryWrapper);
        BeanUtil.copyProperties(problem, entity);
        Map<String, String> problemStatusObj = new HashMap<>();
        problemStatusObj.put("problemStatusCode", entity.getProblemStatusCode());
        entity.setProblemStatusObj(problemStatusObj);
        return entity;
    }

    /**
     * 列表查询 示例
     */
    public List<SafetyProblemTracingDto> queryForSafetyProblemTracingList() {
        return this.queryForList("", false);
    }

    public Page<Map<String, Object>> queryEquipListByProblemId(Page<Map<String, Object>> page, String problemId) {
        LambdaQueryWrapper<SafetyProblemTracing> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SafetyProblemTracing::getSequenceNbr, problemId);
        SafetyProblemTracing problem = this.baseMapper.selectOne(queryWrapper);
        Page<Map<String, Object>> list = new Page<>();
        if (problem.getSourceTypeCode().equals(SafetyProblemSourceTypeEnum.EQUIP.getCode())) {
            list = this.baseMapper.queryEquipListByProblemId(page, problemId);
        } else {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("USE_UNIT_CREDIT_CODE", problem.getPrincipalUnitCode());
            jsonObject.put("number", page.getCurrent());
            jsonObject.put("size", page.getSize());
            Page<JSONObject> result = idxBizJgRegisterInfoService.queryForEquipmentRegisterPage(jsonObject);
            List<Map<String, Object>> finalList = Lists.newArrayList();
            result.getRecords().forEach(item -> {
                Map<String, Object> map = new HashMap<>();
                map.put("record", item.get("SEQUENCE_NBR"));
                map.put("equList", item.get("EQU_LIST"));
                map.put("equListCode", item.get("EQU_LIST_CODE"));
                map.put("equCategory", item.get("EQU_CATEGORY"));
                map.put("useUnitName", item.get("USE_UNIT_NAME"));
                map.put("code96333", item.get("CODE96333"));
                map.put("supervisoryCode", item.get("SUPERVISORY_CODE"));
                map.put("problemStatus", item.get("problemStatus"));
                if (SafetyProblemStatusEnum.UNHANDLED.getCode().equals(item.get("problemStatus"))) {
                    map.put("problemStatusColor", SafetyProblemStatusEnum.UNHANDLED.getColor());
                    map.put("problemStatusName", "异常");
                } else {
                    map.put("problemStatusColor", SafetyProblemStatusEnum.HANDLED.getColor());
                    map.put("problemStatusName", "正常");
                }
                finalList.add(map);
            });
            BeanUtils.copyProperties(result, list);
            list.setRecords(finalList);
        }
        return list;
    }

    public Page<Map<String, Object>> queryPrincipalUnitByProblemId(Page<Map<String, Object>> page, String problemId) {
        LambdaQueryWrapper<SafetyProblemTracing> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SafetyProblemTracing::getSequenceNbr, problemId);
        SafetyProblemTracing problem = this.baseMapper.selectOne(queryWrapper);
        return this.baseMapper.queryPrincipalUnitByProblemId(page, problemId, problem.getSourceTypeCode());
    }

    /**
     * 条件批量添加更新
     *
     * @param entityList 数据
     * @param queryWrapperFunction   条件
     * @return boolean
     */
    @Transactional(rollbackFor = Exception.class)
    public boolean saveOrUpdateBatchByColumns(List<SafetyProblemTracing> entityList, Function<SafetyProblemTracing, QueryWrapper> queryWrapperFunction) {
        Assert.notEmpty(entityList, "error: entityList must not be empty");
        Class<?> cls = currentModelClass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
        Assert.notNull(tableInfo, "error: can not execute. because can not find cache of TableInfo for entity!");
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty(keyProperty, "error: can not execute. because can not find column for id from entity!");
        try (SqlSession batchSqlSession = sqlSessionBatch()) {
            int i = 0;
            for (SafetyProblemTracing entity : entityList) {
//                Object idVal = ReflectionKit.getMethodValue(cls, entity, keyProperty);
                SafetyProblemTracing target = getBaseMapper().selectOne(new QueryWrapper<SafetyProblemTracing>()
                        .eq("problem_type_code", entity.getProblemTypeCode())
                        .eq("source_id", entity.getSourceId())
                        .eq("problem_status_code", entity.getProblemStatusCode()));
                if (Objects.isNull(target)) {
                    batchSqlSession.insert(sqlStatement(SqlMethod.INSERT_ONE), entity);
                } else {
                    Map<String, Object> param = Maps.newHashMap();
                    param.put(Constants.ENTITY, entity);
                    param.put(Constants.WRAPPER, queryWrapperFunction.apply(entity));
                    batchSqlSession.update(sqlStatement(SqlMethod.UPDATE), param);
                }
                // 不知道以后会不会有人说更新失败了还要执行插入 😂😂😂
                if (i >= 1 && i % DEFAULT_BATCH_SIZE == 0) {
                    batchSqlSession.flushStatements();
                }
                i++;
            }
            batchSqlSession.flushStatements();
        }

        return true;
    }

    public Page<Map<String, Object>> queryUserListProblemById(Page<Map<String, Object>> page, String problemId) {
        return this.baseMapper.queryUserListProblemById(page, problemId);
    }
}