package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.InspectionBizServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/dp/biz-inspection")
@Api(tags = "大屏检验检测-业务API")
public class InspectionBizController extends BaseController {

    private InspectionBizServiceImpl inspectionBizService;

    public InspectionBizController(InspectionBizServiceImpl inspectionBizService) {
        this.inspectionBizService = inspectionBizService;
    }


    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectOneForBigScreen/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<Map<String, Object>> selectOneForBigScreen(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(inspectionBizService.selectOneForBigScreen(sequenceNbr, getSelectedOrgInfo().getCompany().getCompanyType()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectOneForBigScreenEqu/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<Page> selectOneForBigScreenEqu(@PathVariable Long sequenceNbr,
                                                        @RequestParam(value = "current") int current,
                                                        @RequestParam(value = "size") int size) {
        return ResponseHelper.buildResponse(inspectionBizService.selectOneForBigScreenEqu(current, size, sequenceNbr, getSelectedOrgInfo().getCompany().getCompanyType()));
    }
}
