package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author Administrator
 */
@Getter
@AllArgsConstructor
public enum OpenBizTypeEnumV2 {

    /**
     * 业务类型
     */
    JY("jy", "检验机构", "检验业务", true),
    JC("jc", "检测机构", "检测业务", true),
    SYDW("jc-sydw", "使用单位", "使用单位电梯检测", false),
    AGW("jc-agw", "安装改造维修单位", "安改维电梯检测", false);

    /**
     * 唯一标识
     */
    private final String code;


    /**
     * 单位类型
     */
    private final String unitType;

    /**
     * 描述
     */
    private final String description;

    /**
     * 是否需要资质
     */
    private final boolean needSaveLicense;


    public static OpenBizTypeEnumV2 getOneByCode(String code) {
        Optional<OpenBizTypeEnumV2> op = Arrays.stream(OpenBizTypeEnumV2.values()).filter(e -> e.getCode().equals(code)).findFirst();
        return op.orElse(null);
    }

    public static OpenBizTypeEnumV2 getOneByUnitType(String unitType) {
        Optional<OpenBizTypeEnumV2> op = Arrays.stream(OpenBizTypeEnumV2.values()).filter(e -> e.getUnitType().equals(unitType)).findFirst();
        return op.orElse(null);
    }
}
