package com.yeejoin.amos.boot.module.elevator.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;


@AllArgsConstructor
@Getter
public enum ImageSizeEnums {

    /**
     * 导出监管码、96333码尺寸
     */
    // 监管码-大
    JG_BIG("JG_BIG", "bigBg.png", 350, 350, 60, 720, 190, 0, 0, 780, 680),
    // 监管码-中
    JG_MID("JG_MID", "centreBg.png", 230, 230, 40, 480, 170, 0, 0, 520, 525),
    // 监管码-小
    JG_MIN("JG_MIN", "smallBg.png", 170, 170, 30, 360, 110, 0, 0, 380, 355),
    // 96333电梯码
    DT("DT", "dt.png", 170, 170, 30, 30, 110, 0, 0, 330, 355);

    String code;
    String bgPath;
    Integer with;
    Integer height;
    Integer size;
    Integer imagesX;
    Integer imagesY;
    Integer text1X;
    Integer text1Y;
    Integer text2X;
    Integer text2Y;


    public static ImageSizeEnums getEnumByCode(String code) {
        for (ImageSizeEnums value : ImageSizeEnums.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

}
