package com.yeejoin.amos.boot.module.common.api.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 动态表单树形分组字段表
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "cb_dynamic_form_column", autoResultMap = true)
public class DynamicFormColumn extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
     * 字段名
     */
    @TableField("field_code")
    private String fieldCode;
    /**
     * 中文名
     */
    @TableField("field_name")
    private String fieldName;
    /**
     * 字段类型(web使用）
     */
    @TableField("field_type")
    private String fieldType;
    /**
     * 字段分组主键
     */
    @TableField("group_id")
    private Long groupId;
    /**
     * 查询策略;全等,模糊,区间
     */
    @TableField("query_strategy")
    private String queryStrategy;
    /**
     * 不能为空
     */
    @TableField("not_null")
    private Boolean notNull;
    /**
     * 是否一行显示(兼容已有动态表单使用)
     */
    @TableField("block")
    private Boolean block;
    /**
     * 所属分组编号
     */
    @TableField("group_code")
    private String groupCode;
    /**
     * 配置json
     */
    @TableField(value = "column_config", typeHandler = JacksonTypeHandler.class)
    private JSONObject columnConfig;
    /**
     * 提示信息
     */
    @TableField("remark")
    private String remark;

    /**
     * 排序字段
     */
    @TableField("sort")
    private int sort;

    /**
     * 组织机构
     */
    @TableField("org_code")
    private String orgCode;
    
}
