package com.yeejoin.amos.boot.module.tcm.api.service;

import com.alibaba.fastjson.JSONObject;

import javax.servlet.http.HttpServletResponse;

/**
 * @description:
 * @author: duanwei
 * @date: 2020-07-02 12:11
 **/
public interface SmallProService {
	/**
	 * 统一提供小程序Token
	 * https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/access-token/auth.getAccessToken.html
	 *
	 * @return
	 */
	String getSmallProToken();

	/**
	 * 统一产生第三方页面二维码
	 * https://developers.weixin.qq.com/miniprogram/dev/framework/open-ability/qr-code.html
	 *
	 * @param access_token 接口调用凭证
	 * @param scene        传递的参数
	 *                     最大32个可见字符，只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~，其它字符请自行编码为合法字符（因不支持%，中文无法使用
	 *                     urlencode 处理，请使用其他编码方式）
	 * @param page         必须是已经发布的小程序存在的页面（否则报错），例如 pages/index/index, 根路径前不要填加
	 *                     /,不能携带参数（参数请放在scene字段里），如果不填写这个字段，默认跳主页面
	 * @param width        二维码的宽度，单位 px，最小 280px，最大 1280px
	 * @param auto_color   自动配置线条颜色，如果颜色依然是黑色，则说明不建议配置主色调，默认 false
	 * @param line_color   auto_color 为 false 时生效，使用 rgb 设置颜色 例如
	 *                     {"r":"xxx","g":"xxx","b":"xxx"} 十进制表示
	 * @param is_hyaline   是否需要透明底色，为 true 时，生成透明底色的小程序
	 * @return
	 */
	String getSmallProQrCode(String access_token, String scene, String page, Long width, Boolean auto_color,
                             JSONObject line_color, Boolean is_hyaline);

	/**
	 * 统一产生第三方页面二维码
	 * https://developers.weixin.qq.com/miniprogram/dev/framework/open-ability/qr-code.html
	 *
	 * @param access_token 接口调用凭证
	 * @param scene        传递的参数
	 *                     最大32个可见字符，只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~，其它字符请自行编码为合法字符（因不支持%，中文无法使用
	 *                     urlencode 处理，请使用其他编码方式）
	 * @param page         必须是已经发布的小程序存在的页面（否则报错），例如 pages/index/index, 根路径前不要填加
	 *                     /,不能携带参数（参数请放在scene字段里），如果不填写这个字段，默认跳主页面
	 * @param width        二维码的宽度，单位 px，最小 280px，最大 1280px
	 * @param auto_color   自动配置线条颜色，如果颜色依然是黑色，则说明不建议配置主色调，默认 false
	 * @param line_color   auto_color 为 false 时生效，使用 rgb 设置颜色 例如
	 *                     {"r":"xxx","g":"xxx","b":"xxx"} 十进制表示
	 * @param is_hyaline   是否需要透明底色，为 true 时，生成透明底色的小程序
	 * @param is_hyaline   是否需要透明底色，为 true 时，生成透明底色的小程序
	 * @return
	 */
	byte[] getSmallProQrCodeByte(String access_token, String scene, String page, Long width, Boolean auto_color,
                                 JSONObject line_color, Boolean is_hyaline);

	/**
	 * 小程序二维码请求-文件流
	 *
	 * @param access_token
	 * @param scene
	 * @param page
	 * @param width
	 * @param auto_color
	 * @param line_color
	 * @param is_hyaline
	 * @param response
	 * @param fileName
	 * @param fileType
	 */
	void getSmallProQrCodeResponse(String access_token, String scene, String page, Long width, Boolean auto_color,
                                   JSONObject line_color, Boolean is_hyaline, HttpServletResponse response, String fileName, String fileType);

	/**
	 * code转session
	 * 
	 * @param code
	 * @return
	 */
	JSONObject getCode2Session(String code);

	/**
	 * 获取sessionKey
	 * 
	 * @param code
	 * @return
	 */
	String getSessionKey(String code);

	/**
	 * 获取openId
	 * 
	 * @param code
	 * @return
	 */
	String getOpenId(String code);

	/**
	 * 获取电话号码
	 * @param session_key
	 * @param encryptedData
	 * @param iv
	 * @return
	 */
	String getPhoneNumber(String session_key, String encryptedData, String iv);

/*	*//**
	 * 微信消息通知推送
	 * @param
	 *//*
	void sendWeChatUpcomingMessage(List<String> openIds, String template, List<String> message) ;*/
	
	String getName();
}
