package com.yeejoin.equipmanage.action;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import com.yeejoin.amos.component.rule.MethodParam;
import com.yeejoin.amos.component.rule.RuleActionBean;
import com.yeejoin.amos.component.rule.RuleMethod;
import com.yeejoin.equipmanage.common.entity.dto.EquipQrDateDto;
import com.yeejoin.equipmanage.common.enums.CalculationRulesEnum;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.service.ICarService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 赋码动作
 * @author DELL
 */
@Component
@RuleActionBean(beanLabel = "动态预案")
@Slf4j
public class UpdateQrCodeAction {

    @Autowired
    private ICarService carService;

    private final String CAR_ID = "carId";

    @RuleMethod(methodLabel = "更新码", project = "车辆更新码颜色")
    public void updateCarQrCode(@MethodParam(paramLabel = "判断值") String value, @MethodParam(paramLabel = "赋码颜色") String color,
                                @MethodParam(paramLabel = "判断对象") Object equipQrDateDto, @MethodParam(paramLabel = "是否启用") Boolean enable,
                                @MethodParam(paramLabel = "计算规则") String rule) {

        if (Boolean.TRUE.equals(enable)) {
            EquipQrDateDto equipQrDateDtoN = JSONObject.parseObject(equipQrDateDto.toString(), EquipQrDateDto.class);
            List<Map<String, String>> data = equipQrDateDtoN.getData();
            String contrast = equipQrDateDtoN.getContrast();
            if (!CollectionUtils.isEmpty(data)) {
                List<String> collect = data.stream().map(map -> {
                    try {
                        String carId = null;
                        String s = map.get(contrast).replace("T", " ");
                        Date date = DateUtils.longStr2Date(s);
                        int i = DateUtils.dateBetween(date, new Date());
                        CalculationRulesEnum anEnum = CalculationRulesEnum.getEnum(rule);
                        switch (anEnum) {
                            case EQ:
                                if (i == Integer.parseInt(value)) {
                                    carId = String.valueOf(map.get(CAR_ID));
                                }
                                break;
                            case GT:
                                if (i > Integer.parseInt(value)) {
                                    carId = String.valueOf(map.get(CAR_ID));
                                }
                                break;
                            case GE:
                                if (i >= Integer.parseInt(value)) {
                                    carId = String.valueOf(map.get(CAR_ID));
                                }
                                break;
                            case LE:
                                if (i <= Integer.parseInt(value)) {
                                    carId = String.valueOf(map.get(CAR_ID));
                                }
                                break;
                            case LT:
                                if (i < Integer.parseInt(value)) {
                                    carId = String.valueOf(map.get(CAR_ID));
                                }
                                break;
                            case NE:
                                if (i != Integer.parseInt(value)) {
                                    carId = String.valueOf(map.get(CAR_ID));
                                }
                                break;
                            default:
                                break;
                        }
                        return carId;
                    } catch (ParseException e) {
                        log.error("日期转换失败");
                        e.printStackTrace();
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                carService.updateCarQrCode(collect, color);
            }

        }
    }
}
