package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.yeejoin.amos.boot.module.jcs.biz.audioToText.SocketClient;
import com.yeejoin.amos.boot.module.jcs.biz.audioToText.streamToText.RealTimeStream2Text;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.net.SocketException;
import java.util.HashMap;

@RestController
@Api(tags = "语音转文字Api")
@RequestMapping(value = "/Audio2TextController")
public class Audio2TextController {

    @Autowired
    RealTimeStream2Text audio2Text;

    @Autowired
    SocketClient socketClient;

    /**
     * 第一步收到转换请求后，启动两个serverSocket,监听不同端口
     * 第一步调用语音融合系统的API并传递两个监听的端口号和本机IP地址
     * 第三步serverSocket收到数据请求，开始将数据推至阿里云语音识别系统进行识别
     * 第四步回调函数中获取识别结果，使用mqtt客户端推送至mqtt服务器
     * 第五步前端订阅消息并进行展示
     *
     * @param cid          通话id
     * @param myNumber     我的手机号
     * @param callerNumber 呼入手机号
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping("/startConvertAndSendAudio")
    @ApiOperation(httpMethod = "GET", value = "测试语音转文字融合接口", notes = "测试语音转文字融合接口")
    public HashMap<String, Object> startConvertAndSendAudio(@RequestParam String cid, @RequestParam String myNumber, @RequestParam String callerNumber) {
        HashMap<String, Object> convert = audio2Text.doTranslate(cid, myNumber, callerNumber);
        return convert;
    }

    /**
     * 测试语音转文字分步接口第一步
     *
     * @param myNumber 我的手机号
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping("/startConvert")
    @ApiOperation(httpMethod = "GET", value = "测试语音转文字分步接口第一步", notes = "测试语音转文字分步接口第一步")
    public HashMap<String, Object> startConvert(@RequestParam String myNumber, @RequestParam String callerNumber) {
        return audio2Text.doTranslate("", myNumber, callerNumber);
    }

    /**
     * 测试语音转文字分步接口第二步
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping("/startSendAudio")
    @ApiOperation(httpMethod = "GET", value = "测试语音转文字分步接口第二步", notes = "测试语音转文字分步接口第二步")
    public String startSendAudio(@RequestParam int port, Integer type) {
        if (type == null) type = 0;
        try {
            socketClient.processUdp(port, type);
        } catch (SocketException e) {
            e.printStackTrace();
        }
        return "success";
    }
}


