package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.UserEvaluationLog;
import com.yeejoin.precontrol.common.service.IUserEvaluationLogService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;


/**
 * 用户评价记录表
 *
 * @author tb
 * @date 2021-01-28
 */
@RestController
@Api(tags = "用户评价记录表Api")
@RequestMapping(value = "/user-evaluation-log", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class UserEvaluationLogController {

    @Autowired
    IUserEvaluationLogService iUserEvaluationLogService;

    /**
     * 新增用户评价记录表
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增用户评价记录表", notes = "新增用户评价记录表")
    public boolean saveUserEvaluationLog(HttpServletRequest request,
                                         @RequestBody List<UserEvaluationLog> userEvaluationLogs) {
        Optional.ofNullable(userEvaluationLogs).orElseThrow(() -> new BadRequest("评价不能为空")).forEach(log -> {
            Optional.ofNullable(log.getEvaluationUserId()).orElseThrow(() -> new BadRequest("评价人不能为空"));
            Optional.ofNullable(log.getPersonId()).orElseThrow(() -> new BadRequest("被评价人不能为空"));
            Optional.ofNullable(log.getRate()).orElseThrow(() -> new BadRequest("评分不能为空"));
        });
        return iUserEvaluationLogService.saveBatch(userEvaluationLogs);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iUserEvaluationLogService.removeById(id);
    }

    /**
     * 根据被评价人id查询列表分页
     *
     * @return
     */
    @RequestMapping(value = "/{personId}/page/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据被评价人id查询列表分页", notes = "根据被评价人id查询列表分页")
    public IPage<UserEvaluationLog> listByPersonId(String pageNum, String pageSize, @PathVariable String personId) {
        return iUserEvaluationLogService.listByPersonId(pageNum, pageSize, personId);
    }

    /**
     * 根据被评价人id查询列表分页
     *
     * @return
     */
    @RequestMapping(value = "/{taskId}/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据被任务id查询列表分页", notes = "根据被任务id查询列表分页")
    public List<UserEvaluationLog> listByTaskId(@PathVariable String taskId) {
        return iUserEvaluationLogService.listByTaskId(taskId);
    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<UserEvaluationLog> listPage(String pageNum, String pageSize,
                                             UserEvaluationLog userEvaluationLog) {

        Page<UserEvaluationLog> pageBean;
        QueryWrapper<UserEvaluationLog> userEvaluationLogQueryWrapper = new QueryWrapper<>();
        Class<? extends UserEvaluationLog> aClass = userEvaluationLog.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(userEvaluationLog);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(userEvaluationLog);
                        userEvaluationLogQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(userEvaluationLog);
                        userEvaluationLogQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(userEvaluationLog);
                        userEvaluationLogQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(userEvaluationLog);
                        userEvaluationLogQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<UserEvaluationLog> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iUserEvaluationLogService.page(pageBean, userEvaluationLogQueryWrapper);
        return page;
    }
}