package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * <pre>
 * 任务状态枚举
 * </pre>
 * @author my
 *
 */
public enum TaskStatusEnum {
	 UNDERWAY("处理中",0),
	 FINISHED("已完成",1),
	 CANCEL("已取消",2),
	 OVERTIME("已超时",3);
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int value;
	


	private TaskStatusEnum(String name, int value) {
		this.name = name;
		this.value = value;
	}


	public static String getName(int value) {
		for (TaskStatusEnum c : TaskStatusEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static int getValue(String name) {
		for (TaskStatusEnum c : TaskStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return -1;
	}


	public static TaskStatusEnum getEnum(int value) {
		for (TaskStatusEnum c : TaskStatusEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static TaskStatusEnum getEnum(String name) {
		for (TaskStatusEnum c : TaskStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (TaskStatusEnum c: TaskStatusEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("value", c.getValue() +"");
			nameList.add(map);
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public int getValue() {
		return value;
	}


	public void setValue(int value) {
		this.value = value;
	}

}
