package com.yeejoin.amos.supervision.core.common.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xixinzhao
 */
@Data
public class DangerDto implements Serializable {

    /**
     * 隐患id
     */
    private Long id;

    /**
     * 隐患名称
     */
    private String dangerName;

    /**
     * 检查项记录id
     */
    private Long bizId;

    /**
     * 隐患级别
     */
    private String dangerLevel;

    /**
     * 隐患等级名称
     */
    private String dangerLevelName;

    /**
     * 状态
     */
    private String dangerState;

    /**
     * 是否删除
     * 0：未删除 1：已删除
     */
    private Boolean deleted;

    /**
     * 业务类型（不同业务创建的隐患以此区分:巡检隐患、防火监督隐患、其他隐患。。。）
     */
    private String bizType;

    /**
     * 整改期限
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date reformLimitDate;


    /**
     * 问题描述
     */
    private String remark;


    /**
     * 检查类型:1-自行检查 ；2计划检查
     */
    private String checkMode;


    /**
     * 隐患图片列表
     */
    private List<String> photoUrl;

    /**
     * 检查项名称
     */
    private String inputItemName;

    /**
     * 检查时间
     */
    private String checkTime;

    /**
     * 2470	49	2052
     * 检查人员名称
     */
    private String checkUserName;

    /**
     * 责任单位
     */
    private String pointName;

    /**
     * 状态
     */
    private String dangerStateName;

    /**
     * 建筑id
     */
    private Long structureId;

    /**
     * 建筑名称
     */
    private String structureName;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 隐患地址
     */
    private String dangerPosition;


    /**
     * 治理方式
     */
    private String reformType;

    /**
     * 治理方式名称
     */
    private String reformTypeName;

    /**
     * 隐患类型
     */
    private String dangerType;

    /**
     * 隐患类型描述
     */
    private String dangerTypeName;
}
