package com.yeejoin.amos.boot.module.cylinder.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.api.dto.CylinderQuestionInfoDto;
import com.yeejoin.amos.boot.module.cylinder.api.entity.CylinderQuestionInfo;
import com.yeejoin.amos.boot.module.cylinder.api.mapper.CylinderQuestionInfoMapper;
import com.yeejoin.amos.boot.module.cylinder.api.service.ICylinderQuestionInfoService;
import com.yeejoin.amos.boot.module.cylinder.biz.job.CompanyQuestionJob;
import com.yeejoin.amos.boot.module.cylinder.biz.job.InspectionQuestionJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

/**
 * 问题信息列表服务实现类
 *
 * @author system_generator
 * @date 2024-06-01
 */
@Service
public class CylinderQuestionInfoServiceImpl extends BaseService<CylinderQuestionInfoDto, CylinderQuestionInfo, CylinderQuestionInfoMapper> implements ICylinderQuestionInfoService {

    @Autowired
    @Lazy
    CompanyQuestionJob companyQuestionJob;

    @Autowired
    @Lazy
    InspectionQuestionJob inspectionQuestionJob;

    /**
     * 分页查询
     */
    public Page<CylinderQuestionInfoDto> queryForCylinderQuestionInfoPage(Page<CylinderQuestionInfoDto> page, String questionType, @Condition(value = Operator.like) String regionCode, String questionAttributionId) {
        return this.queryForPage(page, "happen_date", false, questionType, regionCode, questionAttributionId);
    }

    public void initData() {
        // 资质超期类型问题数据生成
        companyQuestionJob.genCompanyQuestionOfPermissionExpireImpl();
        // 检验超期类型问题数据生成
        inspectionQuestionJob.genOverdueQuestionImpl();
        // 检验不合格类型问题数据生成
        inspectionQuestionJob.genInspectionUnqualifiedQuestionImpl();
        // 未办理使用登记单位问题数据生成
        companyQuestionJob.genCompanyQuestionOfNoUseRegistrationImpl();
    }
}