package com.yeejoin.amos.boot.module.ccs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 消防水源表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireWaterDto", description = "消防水源表")
public class FireWaterDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "唯一标识")
    private String mrid;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "水源类别")
    private String classify;

    @ApiModelProperty(value = "水池类型（消防水池、消防栓、消防水鹤、天然水源）")
    private String type;

    @ApiModelProperty(value = "水池液位")
    private String waterLevel;

    @ApiModelProperty(value = "联系人")
    private String contantPerson;

    @ApiModelProperty(value = "联系电话")
    private String contantNumber;

    @ApiModelProperty(value = "图片")
    private String photoUrl;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

}
