package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireLatentDangerDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireLatentDangerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 隐患信息
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "隐患信息Api")
@RequestMapping(value = "/fire-latent-danger")
public class FireLatentDangerController extends BaseController {

    @Autowired
    FireLatentDangerServiceImpl fireLatentDangerServiceImpl;

    /**
     * 列表数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "隐患列表", notes = "隐患列表")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireLatentDangerDto>> selectForList(
            @ApiParam(value = "前多少条") @RequestParam(required = false) Long top,
            @ApiParam(value = "换流站编号") @RequestParam(required = false) String stationCode) {
        return ResponseHelper.buildResponse(fireLatentDangerServiceImpl.queryForFireLatentDangerList(top, stationCode));
    }
}
