package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireVideoDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireVideoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 消防视频表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防视频表Api")
@RequestMapping(value = "/fire-video")
public class FireVideoController extends BaseController {

    @Autowired
    FireVideoServiceImpl fireVideoServiceImpl;


    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "{stationCode}/page")
    @ApiOperation(httpMethod = "GET", value = "消防视频表分页查询", notes = "消防视频表分页查询")
    public ResponseModel<Page<FireVideoDto>> queryForPage(
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @PathVariable String stationCode) {
        Page<FireVideoDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireVideoServiceImpl.queryForFireVideoPage(page, name, stationCode));
    }

}
