package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireWaterDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireWaterServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 消防水源表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防水源表Api")
@RequestMapping(value = "/fire-water")
public class FireWaterController extends BaseController {

    @Autowired
    FireWaterServiceImpl fireWaterServiceImpl;

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "{stationCode}/page")
    @ApiOperation(httpMethod = "GET", value = "消防水源表分页查询", notes = "消防水源表分页查询")
    public ResponseModel<Page<FireWaterDto>> queryForPage(
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @PathVariable String stationCode) {
        Page<FireWaterDto> page = new Page<FireWaterDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireWaterServiceImpl.queryForFireWaterPage(page, name, stationCode));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消防水源表列表全部数据查询", notes = "消防水源表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireWaterDto>> selectForList() {
        return ResponseHelper.buildResponse(fireWaterServiceImpl.queryForFireWaterList());
    }
}
