package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireBuildingDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireBuilding;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireBuildingMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireBuildingService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 消防建筑表服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireBuildingServiceImpl extends BaseService<FireBuildingDto, FireBuilding, FireBuildingMapper> implements IFireBuildingService {
    /**
     * 分页查询
     */
    public Page<FireBuildingDto> queryForFireBuildingPage(Page<FireBuildingDto> page, @Condition(Operator.like) String name, String stationCode) {
        LambdaQueryWrapper<FireBuilding> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.like(name != null, FireBuilding::getName, name);
        queryWrapper.eq(FireBuilding::getStationCode, stationCode);
        return this.queryForPage(page, "createDate", false, name);
    }


    /**
     * 列表查询 示例
     */
    public List<FireBuildingDto> queryForFireBuildingList() {
        return this.queryForList("", false);
    }
}