package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireVehicleDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireVehicle;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireVehicleMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireVehicleService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 消防车辆信息服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireVehicleServiceImpl extends BaseService<FireVehicleDto, FireVehicle, FireVehicleMapper> implements IFireVehicleService {
    /**
     * 分页查询
     */
    public Page<FireVehicleDto> queryForFireVehiclePage(Page<FireVehicleDto> page, String name, String stationCode) {
        LambdaQueryWrapper<FireVehicleDto> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.like(name != null, FireVehicleDto::getName, name);
        queryWrapper.eq(FireVehicleDto::getStationCode, stationCode);
        return this.queryForPage(page, "createDate", false, name);
    }

    /**
     * 列表查询 示例
     */
    public List<FireVehicleDto> queryForFireVehicleList() {
        return this.queryForList("", false);
    }
}