package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireVideoDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireVideo;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireVideoMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireVideoService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 消防视频表服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireVideoServiceImpl extends BaseService<FireVideoDto, FireVideo, FireVideoMapper> implements IFireVideoService {
    /**
     * 分页查询
     */
    public Page<FireVideoDto> queryForFireVideoPage(Page<FireVideoDto> page, String name, String stationCode) {
        LambdaQueryWrapper<FireVideoDto> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.like(name != null, FireVideoDto::getName, name);
        queryWrapper.eq(FireVideoDto::getStationCode, stationCode);
        return this.queryForPage(page, "createDate", false, name);
    }

    /**
     * 列表查询 示例
     */
    public List<FireVideoDto> queryForFireVideoList() {
        return this.queryForList("", false);
    }
}