package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireWaterDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireWater;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireWaterMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireWaterService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 消防水源表服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireWaterServiceImpl extends BaseService<FireWaterDto, FireWater, FireWaterMapper> implements IFireWaterService {
    /**
     * 分页查询
     */
    public Page<FireWaterDto> queryForFireWaterPage(Page<FireWaterDto> page, String name,String stationCode) {
        LambdaQueryWrapper<FireWaterDto> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.like(name != null, FireWaterDto::getName, name);
        queryWrapper.eq(FireWaterDto::getStationCode,stationCode);
        return this.queryForPage(page, "createDate", false, name);
    }

    /**
     * 列表查询 示例
     */
    public List<FireWaterDto> queryForFireWaterList() {
        return this.queryForList("", false);
    }
}