package com.yeejoin.amos.boot.module.jg.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 问题状态
 */

public enum ProblemStatusEnum {
    NORMAL("正常", "0", "已处理"),
    ABNORMAL("异常", "1", "未处理");

    private String name;

    private String code;
    private String desc;

    ProblemStatusEnum(String name, String code, String desc) {
        this.name = name;
        this.code = code;
        this.desc = desc;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Map<String, String> getNameByCode = new HashMap<>();
    public static Map<String, String> getCodeByName = new HashMap<>();
    public static Map<String, String> getDescByCode = new HashMap<>();
    public static Map<String, String> getNameByDesc = new HashMap<>();

    static {
        for (ProblemStatusEnum e : ProblemStatusEnum.values()) {
            getNameByCode.put(e.code, e.name);
            getNameByDesc.put(e.desc, e.name);
            getDescByCode.put(e.code, e.desc);
            getCodeByName.put(e.name, e.code);
        }
    }
}

