package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.newEquip;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.common.api.converter.CommonCustomConverter;
import com.yeejoin.amos.boot.module.common.biz.event.CommonPublisher;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRegistrationHistory;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.useRegister.UseRegisterUpdateService;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 新增设备编辑处理器
 */
@Component
public class NewEquipDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final UseRegisterUpdateService useRegisterUpdateService;

    protected NewEquipDataChangeHandler(CommonPublisher routerEventPublisher, ApplicationContext applicationContext, UseRegisterUpdateService useRegisterUpdateService) {
        super(routerEventPublisher, applicationContext);
        this.useRegisterUpdateService = useRegisterUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_NEW_EQUIP.name();
    }

    @Override
    public List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap) {
        Map<String, Object> useRegistrationMap = useRegisterUpdateService.getJgUseRegistrationService().getJgUseRegistrationMapper().getUseRegistrationDetail(bizId);
        JgUseRegistration jgUseRegistration = useRegisterUpdateService.getJgUseRegistrationService().getById(useRegistrationMap.get("UseRegistratSequenceNbr").toString());
        JgRegistrationHistory jgRegistrationHistory = useRegisterUpdateService.getJgRegistrationHistoryService().getDteailByRecord(bizId, useRegistrationMap.get("UseRegistratSequenceNbr").toString());
        allChangeColumns.forEach(meta -> {
            if (!ValidationUtil.isEmpty(jgUseRegistration)) {
                if ("receiveCompanyCode".equals(meta.getColumnKey())) {
                    String receiveCompanyCode = meta.getColumnNewValue();
                    if (receiveCompanyCode != null) {
                        jgUseRegistration.setReceiveCompanyCode(receiveCompanyCode);
                        jgUseRegistration.setReceiveOrgName(CommonCustomConverter.ReceiveCompanyCodeConverter.getNameByCode(receiveCompanyCode));
                    }
                }
                if ("oRegDate".equals(meta.getColumnKey())) {
                    String regDateStr = meta.getColumnNewValue();
                    if (regDateStr != null) {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            Date regDate = sdf.parse(regDateStr);
                            jgUseRegistration.setRegDate(regDate);
                        } catch (Exception e) {
                            // 如果日期格式不正确，则设置为null
                            jgUseRegistration.setRegDate(null);
                        }
                    }
                }
                useRegisterUpdateService.getJgUseRegistrationService().updateById(jgUseRegistration);
            }
            if (!ValidationUtil.isEmpty(jgRegistrationHistory)) {
                if ("oRegDate".equals(meta.getColumnKey())) {
                    JSONObject parsedChangeData = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
                    parsedChangeData.put("oRegDate", meta.getColumnNewValue());
                    jgRegistrationHistory.setChangeData(parsedChangeData.toJSONString());
                }
                useRegisterUpdateService.getJgRegistrationHistoryService().updateById(jgRegistrationHistory);
            }
        });
        return Collections.emptyList();
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return true;
    }

    @Override
    public Set<String> getEqs(String record) {
        return Collections.singleton(record);
    }

    @Override
    public Boolean bizIsFinished(String record) {
        return true;
    }

    @Override
    public Set<String> getProjectContraptionIds(String record) {
        return Collections.emptySet();
    }

    @Override
    public void preSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {

    }
}
