package com.yeejoin.amos.boot.module.jyjc.biz.event.rule.service;

import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jyjc.api.enums.JYJCTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.OpenBizTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionEquipInfoModel;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionOrgRefreshEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.RuleCommonServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 不启用规则时，业务处理
 *
 * @author Administrator
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class DisableRuleDataPreparationService {

    private final RuleCommonServiceImpl ruleCommonService;

    private final RedisUtils redisUtils;


    public void onApplicationEvent(InspectionOrgRefreshEvent event) {
        InspectionEquipInfoModel equipInfoModel = event.getInspectionEquipInfoModel();
        String componentKey = equipInfoModel.getComponentKey();
        log.warn("检验类型：{},未启用规则,将返回全部数据", equipInfoModel.getInspectionType());
        this.responseForPublisher(componentKey, this.getAllInspectionOrgList(equipInfoModel));
    }

    private void responseForPublisher(String componentKey, List<TzBaseEnterpriseInfoDto> allInspectionOrgList) {
        try {
            ruleCommonService.publishMqttMessage(componentKey, allInspectionOrgList);
        } catch (MqttException e) {
            log.error("规则不启用时，推送订阅者全部检验检测或者检验机构时失败:{}", e.getMessage());
        }
    }

    private List<TzBaseEnterpriseInfoDto> getAllInspectionOrgList(InspectionEquipInfoModel equipInfoModel) {
        // 提升性能，数据缓存1分钟
        String redisKey = this.getInspectionOrgListRedisKey(equipInfoModel.getInspectionType());
        if (redisUtils.hasKey(redisKey)) {
            return (List<TzBaseEnterpriseInfoDto>) redisUtils.get(redisKey);
        } else {
            List<TzBaseEnterpriseInfoDto> allInspectionOrgList = ruleCommonService.getInspectionUnitList(this.getBizTypeByInspectionType(equipInfoModel.getInspectionType()));
            // 设置为必须处理，前端不再显示《不予处理》按钮
            ruleCommonService.setIsCanNoAccept(allInspectionOrgList, true);
            // 将对象直接存储到缓存，避免 JSON 序列化和反序列化
            redisUtils.set(redisKey, allInspectionOrgList, 60);
            return allInspectionOrgList;
        }
    }

    private String getInspectionOrgListRedisKey(String inspectionType) {
        return String.format("%s:%s", "inspection.rule.org.data", inspectionType);
    }

    private String getBizTypeByInspectionType(String inspectionType) {
        JYJCTypeEnum jyjcTypeEnum = JYJCTypeEnum.of(inspectionType);
        if (jyjcTypeEnum != null) {
            return jyjcTypeEnum.getOpenBizType();
        }
        return OpenBizTypeEnum.JY.getCode();
    }
}
