package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
* 机构/部门/人员表
*
* @author tb
* @date 2021-06-18
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="OrgUsrExcelDto", description="机构/部门/人员表")
public class OrgUsrExcelDto extends BaseDto {

    @ExcelProperty(value = "姓名", index = 0)
    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ExcelIgnore
    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ExcelIgnore
    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ExcelIgnore
    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ExcelIgnore
    @ApiModelProperty(value = "机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）")
    private String bizOrgType;

    @ExcelIgnore
    @ApiModelProperty(value = "所属建筑名称")
    private String buildName;
    @ExcelIgnore
    @ApiModelProperty(value = "所属建筑ID")
    private String buildId;

    @ExcelProperty(value = "所属单位部门", index = 1)
    @ExplicitConstraint(indexNum = 1, sourceClass = CommonExplicitConstraint.class, method = "getparent") //固定下拉内容
    @ApiModelProperty(value = "归属机构/部门/人员")
    private String parentId;

    @ExcelIgnore
    @ApiModelProperty(value = "机构名称")
    private String parentName;

    @ExcelIgnore
    @ApiModelProperty(value = "扩展属性1")
    private String orgExpandAttr1;
    @ExcelIgnore
    @ApiModelProperty(value = "扩展属性2")
    private String orgExpandAttr2;
    @ExcelIgnore
    @ApiModelProperty(value = "扩展属性3")
    private String orgExpandAttr3;
    @ExcelIgnore
    @ApiModelProperty(value = "扩展属性4")
    private String orgExpandAttr4;
    @ExcelIgnore
    private String orgExpandAttr5;
    @ExcelIgnore
    private String orgExpandAttr6;
    @ExcelIgnore
    private String orgExpandAttr7;
    @ExcelIgnore
    private String orgExpandAttr8;
    @ExcelIgnore
    @ApiModelProperty(value = "更新人")
    @TableField(fill= FieldFill.INSERT_UPDATE)
    private String recUserName;

    @ExcelIgnore
    @ApiModelProperty(value = "动态表单值")
    private List<DynamicFormInstance> dynamicFormValue;


    @ExcelProperty(value = "行政职务", index = 2)
    @ExplicitConstraint(type = "XZZW", indexNum =2, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String  administrativePositionCode;//	行政职务
    @ExcelProperty(value = "审核周期", index = 3)
    @ExplicitConstraint(type = "SHZQ", indexNum =3, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String  auditCycle;	//审核周期
    @ExcelProperty(value = "证件类型", index = 4)
    @ExplicitConstraint(type = "RYZJLX", indexNum =4, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String certificatesTypeCode;	//证件类型
    @ExcelProperty(value = "证件号码", index = 5)
    private String  certificatesNumber;//	证件号码
    @ExcelProperty(value = "持证类别", index = 6)
    @ExplicitConstraint(type = "CZLB", indexNum =6, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String certificateType;	//持证类别
    @ExcelProperty(value = "消防管理岗位", index = 7)
    @ExplicitConstraint(type = "XFGLGW", indexNum =7, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String fireManagementPostCode;	//消防管理岗位
    @ExcelProperty(value = "性别", index = 8)
    @ExplicitConstraint(type = "XB", indexNum =8, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String gender;	//性别
    @ExcelProperty(value = "消防管理组织机构内部职务", index = 9)
    @ExplicitConstraint(type = "JGNBZW", indexNum =9, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String  internalPositionCode;	//消防管理组织机构内部职务
    @ExcelProperty(value = "员工编号", index = 10)
    private String personNumber;	//员工编号

    @ExcelProperty(value = "岗位类型", index = 11)
    @ExplicitConstraint(type = "GWMC", indexNum =11, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String  positionType;	//岗位类型

    @ExcelProperty(value = "是否进行安全培训", index = 12)
    @ExplicitConstraint(type = "AQPX", indexNum =12, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String  safetyTraining;	//是否进行安全培训

    @ExcelProperty(value = "人员状态", index = 13)
    @ExplicitConstraint(type = "RYZT", indexNum =13, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String stateCode;	//人员状态

    @ExcelProperty(value = "联系电话", index = 14)
    private String  telephone;	//联系电话

    @ExcelProperty(value = "人员类型", index = 15)
    @ExplicitConstraint(type = "DWRYLX", indexNum =15, sourceClass = CommonExplicitConstraint.class) //动态下拉内
    private String peopleType;	//人员类型

    @ExplicitConstraint(indexNum = 16, sourceClass = CommonExplicitConstraint.class, method = "getNations") //固定下拉内容
    @ExcelProperty(value = "民族", index = 16)
    @ApiModelProperty(value = "民族")
    private String nation;

    @ExcelProperty(value = "出生日期", index = 17)
    @ApiModelProperty(value = "出生日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date birthdayTime;

    @ExplicitConstraint(indexNum = 18, sourceClass = CommonExplicitConstraint.class, method = "getMaritalStatus") //固定下拉内容
    @ExcelProperty(value = "婚姻状况", index = 18)
    @ApiModelProperty(value = "婚姻状况")
    private String maritalStatus;

    @ExplicitConstraint(indexNum = 19, sourceClass = CommonExplicitConstraint.class,method="getCitys") //动态下拉内容
    @ExcelProperty(value = "户籍所在地", index = 19)
    @ApiModelProperty(value = "籍贯/户口所在地的值")
    private String nativePlace;

    @ExcelProperty(value = "籍贯/户口所在地详细地址", index = 20)
    @ApiModelProperty(value = "籍贯/户口所在地详细地址")
    private String nativePlaceVal;

    @ExplicitConstraint(indexNum = 21, sourceClass = CommonExplicitConstraint.class, method = "getPoliticalOutlook") //固定下拉内容
    @ExcelProperty(value = "政治面貌", index = 21)
    @ApiModelProperty(value = "政治面貌代码")
    private String politicalOutlook;

    @ExplicitConstraint(indexNum = 22, sourceClass = CommonExplicitConstraint.class,method="getCitys") //动态下拉内容// BUG 2760 修改消防人员导出模板和 导入问题 bykongfm
    @ExcelProperty(value = "现居住地", index = 22)
    @ApiModelProperty(value = "现居住地")
    private String residenceDetails;

    @ExcelProperty(value = "现居住地详细地址", index = 23)
    @ApiModelProperty(value = "现居住地详细地址")
    private String residenceDetailVal;

    @ExcelProperty(value = "住宿情况", index = 24)
    @ApiModelProperty(value = "住宿情况")
    private String airportAccommodation;

    @ExcelProperty(value = "紧急联系人", index = 25)
    @ApiModelProperty(value = "紧急联系人")
    private String emergencyContact;

    @ExplicitConstraint(type = "RJGX", indexNum = 26, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "与紧急联系人关系", index = 26)
    @ApiModelProperty(value = "紧急联系人与本人所属关系")
    private String relationship;

    @ExcelProperty(value = "紧急联系人电话", index = 27)
    @ApiModelProperty(value = "紧急联系人电话")
    private String emergencyContactPhone;

    @ApiModelProperty(value = "员工层级")
    @ExcelProperty(value = "员工层级", index = 28)
    @ExplicitConstraint(type = "YGCJ", indexNum = 28, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    private String employeeHierarchy;

    @ApiModelProperty(value = "岗位资质")
    @ExplicitConstraint(type = "GWZZ", indexNum = 29, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "岗位资质", index = 29)
    private String postQualification;

    /*************************学历教育***********************/
    @ApiModelProperty(value = "第一学历")
    @ExplicitConstraint(type = "XLLX", indexNum = 30, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "第一学历", index = 30)
    private String firstDegree;

    @ApiModelProperty(value = "最高学历")
    @ExplicitConstraint(type = "XLLX", indexNum = 31, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "最高学历", index = 31)
    private String highestEducation;

    @ApiModelProperty(value = "学位")
    @ExplicitConstraint(type = "XWLX", indexNum = 32, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "学位", index = 32)
    private String academicDegree;

    @ApiModelProperty(value = "毕业院校")
    @ExcelProperty(value = "毕业院校", index = 33)
    private String school;

    @ApiModelProperty(value = "毕业专业名称")
    @ExcelProperty(value = "毕业专业名称", index = 34)
    private String professionalName;


    /*************************工作履历岗***********************/
    @ApiModelProperty(value = "参加工作时间")
    @ExcelProperty(value = "参加工作时间", index = 35)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date workingHours;

    @ApiModelProperty(value = "参加消防部门工作时间")
    @ExcelProperty(value = "参加消防部门工作时间", index = 36)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date fireWorkingHours;

    @ExcelIgnore
    @ApiModelProperty(value = "单位人员id")
    private String orgUsrId;

    @ExcelIgnore
    @ApiModelProperty(value = "消防人员id")
    private Long firefightersId;

}
